package com.litongjava.db.activerecord.stat;

import com.litongjava.lite.Lite;
import com.litongjava.tio.utils.thread.TioThreadUtils;

/**
 * 保存数据到sql lite
 * 
 * @author Tong Li
 *
 */
public class LiteSqlStatementStat implements ISqlStatementStat {

  @Override
  public void save(String name, String sqlType, String sql, Object[] paras, int size, long startTimeMillis, long elapsed, boolean writeSync) {
    if (writeSync) {
      Lite.saveSqlStatementStat(name, sqlType, sql, paras, size, startTimeMillis, elapsed);
    } else {
      TioThreadUtils.submit(() -> {
        Lite.saveSqlStatementStat(name, sqlType, sql, paras, size, startTimeMillis, elapsed);
      });
    }
  }

}
