/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.db.activerecord;

import com.jfinal.kit.StrKit;
import com.litongjava.db.activerecord.CPI;
import com.litongjava.db.activerecord.Config;
import com.litongjava.db.activerecord.Db;
import com.litongjava.db.activerecord.DbPro;
import com.litongjava.db.activerecord.Model;
import com.litongjava.db.activerecord.Record;
import com.litongjava.db.activerecord.Table;
import com.litongjava.db.activerecord.TableMapping;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public final class DbKit {
    public static final int DB_BATCH_COUNT = 1024;
    static Config config = null;
    static List<Config> replicaConfigs = null;
    static Config brokenConfig = Config.createBrokenConfig();
    static List<Config> brokenConfigs = null;
    private static final AtomicInteger counter = new AtomicInteger(0);
    private static Map<Class<? extends Model>, Config> modelToConfig = new HashMap<Class<? extends Model>, Config>(512, 0.5f);
    private static Map<String, Config> configNameToConfig = new HashMap<String, Config>(32, 0.25f);
    static final Object[] NULL_PARA_ARRAY = new Object[0];
    public static final String MAIN_CONFIG_NAME = "main";
    public static final String REPLICA_CONFIG_NAME = "replica";
    public static final int DEFAULT_TRANSACTION_LEVEL = 4;

    private DbKit() {
    }

    public static void addConfig(Config config) {
        if (config == null) {
            throw new IllegalArgumentException("Config can not be null");
        }
        if (configNameToConfig.containsKey(config.getName())) {
            throw new IllegalArgumentException("Config already exists: " + config.getName());
        }
        configNameToConfig.put(config.getName(), config);
        if (MAIN_CONFIG_NAME.equals(config.getName())) {
            DbKit.config = config;
            Db.init(DbKit.config.getName());
        }
        if (DbKit.config == null) {
            DbKit.config = config;
            Db.init(DbKit.config.getName());
        }
    }

    public static void addReplicaConfigs(List<Config> configs) {
        for (Config config : configs) {
            if (config == null) {
                throw new IllegalArgumentException("Config can not be null");
            }
            if (configNameToConfig.containsKey(config.getName())) {
                throw new IllegalArgumentException("Config already exists: " + config.getName());
            }
            configNameToConfig.put(config.getName(), config);
        }
        replicaConfigs = configs;
        Db.initReplicas(replicaConfigs);
    }

    public static Config removeConfig(String configName) {
        if (config != null && config.getName().equals(configName)) {
            config = null;
        }
        Db.removeDbProWithConfig(configName);
        return configNameToConfig.remove(configName);
    }

    static void addModelToConfigMapping(Class<? extends Model> modelClass, Config config) {
        modelToConfig.put(modelClass, config);
    }

    public static Config getConfig() {
        return config;
    }

    public static Config getReadConfig() {
        if (replicaConfigs != null) {
            return DbKit.useReplica();
        }
        return config;
    }

    public static Config useReplica() {
        int index = counter.getAndIncrement() % replicaConfigs.size();
        return replicaConfigs.get(index);
    }

    public static Config getConfig(String configName) {
        return configNameToConfig.get(configName);
    }

    public static Config getConfig(Class<? extends Model> modelClass) {
        return modelToConfig.get(modelClass);
    }

    static final void close(ResultSet rs, Statement st) throws SQLException {
        if (rs != null) {
            rs.close();
        }
        if (st != null) {
            st.close();
        }
    }

    static final void close(ResultSet rs) throws SQLException {
        if (rs != null) {
            rs.close();
        }
    }

    static final void close(Statement st) throws SQLException {
        if (st != null) {
            st.close();
        }
    }

    public static Set<Map.Entry<String, Config>> getConfigSet() {
        return configNameToConfig.entrySet();
    }

    public static Class<? extends Model> getUsefulClass(Class<? extends Model> modelClass) {
        String n = modelClass.getName();
        return n.indexOf("_$$_") > -1 || n.indexOf("$$Enhancer") > -1 ? modelClass.getSuperclass() : modelClass;
    }

    public static List<Integer> batchListUpdate(List<? extends Model> modelList, int batchSize, String db) {
        if (modelList == null || modelList.size() == 0) {
            return new ArrayList<Integer>();
        }
        HashMap<String, BatchInfo> modelUpdateMap = new HashMap<String, BatchInfo>();
        for (Model model : modelList) {
            Set<String> modifyFlag = CPI.getModifyFlag(model);
            Config config = CPI.getConfig(model);
            Table table = TableMapping.me().getTable(model.getClass());
            String[] pKeys = table.getPrimaryKey();
            Map<String, Object> attrs = CPI.getAttrs(model);
            ArrayList<String> attrNames = new ArrayList<String>();
            for (Map.Entry<String, Object> e : attrs.entrySet()) {
                String attr = e.getKey();
                if (!modifyFlag.contains(attr) || config.getDialect().isPrimaryKey(attr, pKeys) || !table.hasColumnLabel(attr)) continue;
                attrNames.add(attr);
            }
            for (String pKey : pKeys) {
                attrNames.add(pKey);
            }
            String columns = StrKit.join((String[])attrNames.toArray(new String[attrNames.size()]), (String)",");
            BatchInfo updateInfo = (BatchInfo)modelUpdateMap.get(columns);
            if (updateInfo == null) {
                updateInfo = new BatchInfo();
                updateInfo.list = new ArrayList();
                StringBuilder sql = new StringBuilder();
                config.getDialect().forModelUpdate(TableMapping.me().getTable(model.getClass()), attrs, modifyFlag, sql, new ArrayList<Object>());
                updateInfo.sql = sql.toString();
                modelUpdateMap.put(columns, updateInfo);
            }
            updateInfo.list.add(model);
        }
        return DbKit.batchModelList(modelList, batchSize, db, modelUpdateMap);
    }

    public static List<Integer> batchListUpdate(List<? extends Model> modelList) {
        return DbKit.batchListUpdate(modelList, 1024, null);
    }

    public static List<Integer> batchListUpdate(List<? extends Model> modelList, String db) {
        return DbKit.batchListUpdate(modelList, 1024, db);
    }

    private static List<Integer> batchModelList(List list, int batchSize, String db, Map<String, BatchInfo> modelUpdateMap) {
        ArrayList<Integer> ret = new ArrayList<Integer>(list.size());
        DbPro dbPro = StrKit.isBlank((String)db) ? Db.use() : Db.use(db);
        for (Map.Entry<String, BatchInfo> entry : modelUpdateMap.entrySet()) {
            int[] batch;
            for (int i : batch = dbPro.batch(entry.getValue().sql, entry.getKey(), entry.getValue().list, batchSize)) {
                ret.add(i);
            }
        }
        return ret;
    }

    public static List<Integer> batchListSave(List<? extends Model> modelList, int batchSize, String db) {
        if (modelList == null || modelList.size() == 0) {
            return new ArrayList<Integer>();
        }
        HashMap<String, BatchInfo> modelUpdateMap = new HashMap<String, BatchInfo>();
        for (Model model : modelList) {
            Config config = CPI.getConfig(model);
            Map<String, Object> attrs = CPI.getAttrs(model);
            int index = 0;
            StringBuilder columns = new StringBuilder();
            for (Map.Entry<String, Object> e : attrs.entrySet()) {
                if (index++ > 0) {
                    columns.append(',');
                }
                columns.append(e.getKey());
            }
            String cs = columns.toString();
            BatchInfo batchInfo = (BatchInfo)modelUpdateMap.get(cs);
            if (batchInfo == null) {
                batchInfo = new BatchInfo();
                batchInfo.list = new ArrayList();
                StringBuilder sql = new StringBuilder();
                config.getDialect().forModelSave(TableMapping.me().getTable(model.getClass()), attrs, sql, new ArrayList<Object>());
                batchInfo.sql = sql.toString();
                modelUpdateMap.put(cs, batchInfo);
            }
            batchInfo.list.add(model);
        }
        return DbKit.batchModelList(modelList, batchSize, db, modelUpdateMap);
    }

    public static List<Integer> batchListSave(List<? extends Model> modelList) {
        return DbKit.batchListSave(modelList, 1024, null);
    }

    public static List<Integer> batchListSave(List<? extends Model> modelList, String db) {
        return DbKit.batchListSave(modelList, 1024, db);
    }

    public static List<Integer> batchListSave(String tableName, List<? extends Record> recordList, int batchSize, String db) {
        if (recordList == null || recordList.size() == 0) {
            return new ArrayList<Integer>();
        }
        HashMap<String, BatchInfo> updateMap = new HashMap<String, BatchInfo>();
        for (Record record : recordList) {
            Map<String, Object> attrs = record.getColumns();
            int index = 0;
            StringBuilder columns = new StringBuilder();
            for (Map.Entry<String, Object> e : attrs.entrySet()) {
                if (index++ > 0) {
                    columns.append(',');
                }
                columns.append(e.getKey());
            }
            String cs = columns.toString();
            BatchInfo batchInfo = (BatchInfo)updateMap.get(cs);
            if (batchInfo == null) {
                batchInfo = new BatchInfo();
                batchInfo.list = new ArrayList();
                StringBuilder sql = new StringBuilder();
                Db.use().getConfig().getDialect().forDbSave(tableName, new String[0], record, sql, new ArrayList<Object>());
                batchInfo.sql = sql.toString();
                updateMap.put(cs, batchInfo);
            }
            batchInfo.list.add(record);
        }
        return DbKit.batchModelList(recordList, batchSize, db, updateMap);
    }

    public static List<Integer> batchListSave(String tableName, List<? extends Record> recordList) {
        return DbKit.batchListSave(tableName, recordList, 1024, null);
    }

    public static StringBuilder buildInSqlPara(List<Object> paras, StringBuilder sb, Object[] inParas) {
        sb.append("(");
        for (int i = 0; i < inParas.length; ++i) {
            paras.add(inParas[i]);
            if (i < inParas.length - 1) {
                sb.append("?,");
                continue;
            }
            sb.append("?)");
        }
        return sb;
    }

    public static class BatchInfo {
        public String sql;
        public List list;
    }
}

