/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.db.activerecord.builder;

import com.litongjava.db.activerecord.ModelBuilder;
import com.litongjava.tio.utils.json.Json;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.postgresql.util.PGobject;

public class BuilderKit {
    public static Byte getByte(ResultSet rs, int i) throws SQLException {
        Object value = rs.getObject(i);
        if (value != null) {
            value = Byte.parseByte(value + "");
            return (Byte)value;
        }
        return null;
    }

    public static Short getShort(ResultSet rs, int i) throws SQLException {
        Object value = rs.getObject(i);
        if (value != null) {
            value = Short.parseShort(value + "");
            return (Short)value;
        }
        return null;
    }

    public static Object getColumnValue(int[] types, ResultSet rs, int i) throws SQLException {
        Object value = null;
        if (types[i] < 91) {
            value = rs.getObject(i);
            if (types[i] == 5 && value instanceof Integer) {
                value = ((Integer)value).shortValue();
            }
        } else if (types[i] == 93) {
            value = rs.getTimestamp(i);
        } else if (types[i] == 91) {
            value = rs.getDate(i);
        } else if (types[i] == 1111) {
            PGobject pGobject;
            value = rs.getObject(i);
            if (value instanceof PGobject && ("json".equals((pGobject = (PGobject)value).getType()) || "jsonb".equals(pGobject.getType())) && "[null]".equals(value = pGobject.getValue())) {
                value = null;
            }
        } else {
            value = types[i] == 2005 ? ModelBuilder.me.handleClob(rs.getClob(i)) : (types[i] == 2011 ? ModelBuilder.me.handleClob(rs.getNClob(i)) : (types[i] == 2004 ? (Object)ModelBuilder.me.handleBlob(rs.getBlob(i)) : (types[i] == 2003 ? ModelBuilder.me.handleArray(rs.getArray(i)) : rs.getObject(i))));
        }
        return value;
    }

    public static Object parseJsonField(String stringValue) {
        if (stringValue.startsWith("[{") && stringValue.endsWith("}]")) {
            List lists = Json.getJson().parseToListMap(stringValue, String.class, Object.class);
            return lists;
        }
        if (stringValue.startsWith("[") && stringValue.endsWith("]")) {
            return Json.getJson().parseArray(stringValue);
        }
        if (stringValue.startsWith("{") && stringValue.endsWith("}")) {
            Map map = Json.getJson().parseToMap(stringValue, String.class, Object.class);
            return map;
        }
        if (stringValue.startsWith("\"") && stringValue.endsWith("\"")) {
            return Json.getJson().parse(stringValue);
        }
        return stringValue;
    }
}

