/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.db.activerecord.dialect;

import com.litongjava.db.activerecord.Config;
import com.litongjava.db.activerecord.Model;
import com.litongjava.db.activerecord.ModelBuilder;
import com.litongjava.db.activerecord.RecordBuilder;
import com.litongjava.db.activerecord.Row;
import com.litongjava.db.activerecord.Table;
import com.litongjava.db.activerecord.builder.KeepByteAndShortModelBuilder;
import com.litongjava.db.activerecord.builder.KeepByteAndShortRecordBuilder;
import com.litongjava.db.activerecord.dialect.DialectUtils;
import com.litongjava.db.kit.SqlParseKit;
import com.litongjava.model.page.Page;
import com.litongjava.tio.utils.json.JsonUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Array;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;

public abstract class Dialect {
    protected boolean keepByteAndShort = false;
    protected ModelBuilder modelBuilder = ModelBuilder.me;
    protected RecordBuilder recordBuilder = RecordBuilder.me;

    public abstract String forTableBuilderDoBuild(String var1);

    public abstract String forPaginate(int var1, int var2, StringBuilder var3);

    public abstract String forModelFindById(Table var1, String var2);

    public abstract String forModelDeleteById(Table var1);

    public abstract String forDbDeleteByField(String var1, String var2);

    public abstract void forModelSave(Table var1, Map<String, Object> var2, StringBuilder var3, List<Object> var4);

    public abstract void forModelUpdate(Table var1, Map<String, Object> var2, Set<String> var3, StringBuilder var4, List<Object> var5);

    public abstract String forDbFindById(String var1, String[] var2);

    public abstract String forDbFindColumnsById(String var1, String var2, String[] var3);

    public abstract String forDbFindColumns(String var1, String var2);

    public abstract String forDbDeleteById(String var1, String[] var2);

    public abstract StringBuffer forDbFind(String var1, String var2, Row var3, List<Object> var4);

    public abstract StringBuffer forDbFindByField(String var1, String var2, String var3, Object var4, List<Object> var5);

    public abstract void forDbSave(String var1, String[] var2, Row var3, StringBuilder var4, List<Object> var5);

    public abstract void forDbDelete(String var1, String[] var2, Row var3, StringBuilder var4, List<Object> var5);

    public abstract void forDbUpdate(String var1, String[] var2, Object[] var3, Row var4, StringBuilder var5, List<Object> var6);

    public abstract void forDbUpdate(String var1, String[] var2, Object[] var3, Row var4, StringBuilder var5, List<Object> var6, String[] var7);

    public abstract String forColumns(String var1);

    public abstract String forExistsByFields(String var1, String var2);

    public abstract void transformJsonFields(Row var1, String[] var2);

    public abstract void transformJsonFields(List<Row> var1, String[] var2);

    public String forFindAll(String tableName) {
        return "select * from " + tableName;
    }

    public Dialect setKeepByteAndShort(boolean keepByteAndShort) {
        this.keepByteAndShort = keepByteAndShort;
        if (keepByteAndShort) {
            if (this.modelBuilder.getClass() == ModelBuilder.class) {
                this.modelBuilder = KeepByteAndShortModelBuilder.me;
            }
            if (this.recordBuilder.getClass() == RecordBuilder.class) {
                this.recordBuilder = KeepByteAndShortRecordBuilder.me;
            }
        } else {
            if (this.modelBuilder.getClass() == KeepByteAndShortModelBuilder.class) {
                this.modelBuilder = ModelBuilder.me;
            }
            if (this.recordBuilder.getClass() == KeepByteAndShortRecordBuilder.class) {
                this.recordBuilder = RecordBuilder.me;
            }
        }
        return this;
    }

    public boolean isKeepByteAndShort() {
        return this.keepByteAndShort;
    }

    public Dialect setModelBuilder(ModelBuilder modelBuilder) {
        this.modelBuilder = modelBuilder;
        return this;
    }

    public Dialect setRecordBuilder(RecordBuilder recordBuilder) {
        this.recordBuilder = recordBuilder;
        return this;
    }

    public <T> List<T> buildModelList(ResultSet rs, Class<? extends Model> modelClass) throws SQLException, ReflectiveOperationException {
        return this.modelBuilder.build(rs, modelClass);
    }

    public <T> void eachModel(ResultSet rs, Class<? extends Model> modelClass, Function<T, Boolean> func) throws SQLException, ReflectiveOperationException {
        this.modelBuilder.build(rs, modelClass, func);
    }

    public List<Row> buildRecordList(Config config, ResultSet rs) throws SQLException {
        return this.recordBuilder.build(config, rs);
    }

    public List<Row> buildRecordListWithJsonFields(Config config, ResultSet rs, String[] jsonFields) throws SQLException {
        return this.recordBuilder.buildJsonFields(config, rs, jsonFields);
    }

    public void eachRecord(Config config, ResultSet rs, Function<Row, Boolean> func) throws SQLException {
        this.recordBuilder.build(config, rs, func);
    }

    public void getModelGeneratedKey(Model<?> model, PreparedStatement pst, Table table) throws SQLException {
        String[] pKeys = table.getPrimaryKey();
        ResultSet rs = pst.getGeneratedKeys();
        for (String pKey : pKeys) {
            Class<?> colType;
            if (model.get(pKey) != null && !this.isOracle() || !rs.next() || (colType = table.getColumnType(pKey)) == null) continue;
            if (colType == Integer.class || colType == Integer.TYPE) {
                model.set(pKey, rs.getInt(1));
                continue;
            }
            if (colType == Long.class || colType == Long.TYPE) {
                model.set(pKey, rs.getLong(1));
                continue;
            }
            if (colType == BigInteger.class) {
                this.processGeneratedBigIntegerKey(model, pKey, rs.getObject(1));
                continue;
            }
            model.set(pKey, rs.getObject(1));
        }
        rs.close();
    }

    protected void processGeneratedBigIntegerKey(Model<?> model, String pKey, Object v) {
        if (v instanceof BigInteger) {
            model.set(pKey, (BigInteger)v);
        } else if (v instanceof Number) {
            Number n = (Number)v;
            model.set(pKey, BigInteger.valueOf(n.longValue()));
        } else {
            model.set(pKey, v);
        }
    }

    public void getRecordGeneratedKey(PreparedStatement pst, Row record, String[] pKeys) throws SQLException {
        ResultSet rs = pst.getGeneratedKeys();
        for (String pKey : pKeys) {
            if (record.get(pKey) != null && !this.isOracle() || !rs.next()) continue;
            record.set(pKey, rs.getObject(1));
        }
        rs.close();
    }

    public boolean isOracle() {
        return false;
    }

    public boolean isTakeOverDbPaginate() {
        return false;
    }

    public <T> Page<T> takeOverDbPaginate(Connection conn, int pageNumber, int pageSize, Boolean isGroupBySql, String totalRowSql, StringBuilder findSql, Object ... paras) throws SQLException {
        throw new RuntimeException("You should implements this method in " + this.getClass().getName());
    }

    public boolean isTakeOverModelPaginate() {
        return false;
    }

    public Page takeOverModelPaginate(Connection conn, Class<? extends Model> modelClass, int pageNumber, int pageSize, Boolean isGroupBySql, String totalRowSql, StringBuilder findSql, Object ... paras) throws Exception {
        throw new RuntimeException("You should implements this method in " + this.getClass().getName());
    }

    public void fillStatement(PreparedStatement pst, List<Object> paras) throws SQLException {
        int size = paras.size();
        for (int i = 0; i < size; ++i) {
            pst.setObject(i + 1, paras.get(i));
        }
    }

    public void fillStatement(PreparedStatement pst, Object ... paras) throws SQLException {
        for (int i = 0; i < paras.length; ++i) {
            pst.setObject(i + 1, paras[i]);
        }
    }

    public String getDefaultPrimaryKey() {
        return "id";
    }

    public boolean isPrimaryKey(String colName, String[] pKeys) {
        for (String pKey : pKeys) {
            if (!colName.equalsIgnoreCase(pKey)) continue;
            return true;
        }
        return false;
    }

    public void fillPst(PreparedStatement pst, int i, Object value) throws SQLException {
        if (value instanceof String) {
            pst.setString(i + 1, (String)value);
        } else if (value instanceof java.util.Date) {
            if (value instanceof Date) {
                pst.setDate(i + 1, (Date)value);
            } else if (value instanceof Timestamp) {
                pst.setTimestamp(i + 1, (Timestamp)value);
            } else {
                java.util.Date d = (java.util.Date)value;
                pst.setTimestamp(i + 1, new Timestamp(d.getTime()));
            }
        } else if (value instanceof Long) {
            pst.setLong(i + 1, (Long)value);
        } else if (value instanceof Integer) {
            pst.setInt(i + 1, (Integer)value);
        } else if (value instanceof Short) {
            pst.setShort(i + 1, (Short)value);
        } else if (value instanceof Byte) {
            pst.setByte(i + 1, (Byte)value);
        } else if (value instanceof Double) {
            pst.setDouble(i + 1, (Double)value);
        } else if (value instanceof Float) {
            pst.setFloat(i + 1, ((Float)value).floatValue());
        } else if (value instanceof BigDecimal) {
            pst.setBigDecimal(i + 1, (BigDecimal)value);
        } else if (value instanceof Boolean) {
            pst.setBoolean(i + 1, (Boolean)value);
        } else if (value instanceof LocalDate) {
            pst.setDate(i + 1, Date.valueOf((LocalDate)value));
        } else if (value instanceof LocalDateTime) {
            pst.setTimestamp(i + 1, Timestamp.valueOf((LocalDateTime)value));
        } else if (value instanceof byte[]) {
            pst.setBytes(i + 1, (byte[])value);
        } else if (value instanceof UUID) {
            pst.setObject(i + 1, value, 1111);
        } else if (value instanceof Enum) {
            pst.setString(i + 1, ((Enum)value).name());
        } else if (value instanceof List) {
            Array sqlArray = pst.getConnection().createArrayOf("text", ((List)value).toArray());
            pst.setArray(i + 1, sqlArray);
        } else {
            String json = JsonUtils.toJson((Object)value);
            pst.setObject(i + 1, json);
        }
    }

    public String forPaginateTotalRow(String select, String sqlExceptSelect, Object ext) {
        return "select count(*) " + SqlParseKit.replaceOrderBy(sqlExceptSelect);
    }

    public void trimPrimaryKeys(String[] pKeys) {
        DialectUtils.trimPrimaryKeys(pKeys);
    }
}

