/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.db.activerecord.dialect;

import com.litongjava.db.activerecord.CPI;
import com.litongjava.db.activerecord.Row;
import com.litongjava.db.activerecord.Table;
import com.litongjava.db.activerecord.dialect.Dialect;
import com.litongjava.db.activerecord.dialect.DialectUtils;
import com.litongjava.tio.utils.json.Json;
import com.litongjava.tio.utils.json.JsonUtils;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class MysqlDialect
extends Dialect {
    @Override
    public String forTableBuilderDoBuild(String tableName) {
        if (tableName.contains(".")) {
            return "select * from " + tableName + " where 1 = 2";
        }
        return "select * from `" + tableName + "` where 1 = 2";
    }

    @Override
    public String forFindAll(String tableName) {
        if (tableName.contains(".")) {
            return "select * from " + tableName;
        }
        return "select * from `" + tableName + "`";
    }

    @Override
    public void forModelSave(Table table, Map<String, Object> attrs, StringBuilder sql, List<Object> paras) {
        sql.append("insert into `").append(table.getName()).append("`(");
        StringBuilder temp = new StringBuilder(") values(");
        for (Map.Entry<String, Object> e : attrs.entrySet()) {
            String colName = e.getKey();
            if (!table.hasColumnLabel(colName)) continue;
            if (paras.size() > 0) {
                sql.append(", ");
                temp.append(", ");
            }
            sql.append('`').append(colName).append('`');
            temp.append('?');
            paras.add(e.getValue());
        }
        sql.append(temp.toString()).append(')');
    }

    @Override
    public String forModelDeleteById(Table table) {
        String[] pKeys = table.getPrimaryKey();
        StringBuilder sql = new StringBuilder(45);
        String tableName = table.getName();
        if (tableName.contains(".")) {
            sql.append("delete from ").append(tableName);
        } else {
            sql.append("delete from `").append(tableName).append("`");
        }
        sql.append(" where ");
        for (int i = 0; i < pKeys.length; ++i) {
            if (i > 0) {
                sql.append(" and ");
            }
            sql.append('`').append(pKeys[i]).append("` = ?");
        }
        return sql.toString();
    }

    @Override
    public void forModelUpdate(Table table, Map<String, Object> attrs, Set<String> modifyFlag, StringBuilder sql, List<Object> paras) {
        String tableName = table.getName();
        if (tableName.contains(".")) {
            sql.append("update ").append(tableName);
        } else {
            sql.append("update `").append(tableName).append("`");
        }
        sql.append(" set ");
        String[] pKeys = table.getPrimaryKey();
        for (Map.Entry<String, Object> e : attrs.entrySet()) {
            String colName = e.getKey();
            if (!modifyFlag.contains(colName) || this.isPrimaryKey(colName, pKeys) || !table.hasColumnLabel(colName)) continue;
            if (paras.size() > 0) {
                sql.append(", ");
            }
            sql.append('`').append(colName).append("` = ? ");
            paras.add(e.getValue());
        }
        sql.append(" where ");
        for (int i = 0; i < pKeys.length; ++i) {
            if (i > 0) {
                sql.append(" and ");
            }
            sql.append('`').append(pKeys[i]).append("` = ?");
            paras.add(attrs.get(pKeys[i]));
        }
    }

    @Override
    public String forModelFindById(Table table, String columns) {
        String tableName = table.getName();
        String[] pKeys = table.getPrimaryKey();
        return DialectUtils.forDbFindColumnsById(tableName, columns, pKeys);
    }

    @Override
    public String forDbFindById(String tableName, String[] pKeys) {
        tableName = tableName.trim();
        DialectUtils.trimPrimaryKeys(pKeys);
        StringBuilder sql = new StringBuilder("select * from ");
        if (tableName.contains(".")) {
            sql.append(tableName);
        } else {
            sql.append("`").append(tableName).append("`");
        }
        sql.append(" where ");
        for (int i = 0; i < pKeys.length; ++i) {
            if (i > 0) {
                sql.append(" and ");
            }
            sql.append('`').append(pKeys[i]).append("` = ?");
        }
        return sql.toString();
    }

    @Override
    public String forDbDeleteById(String tableName, String[] pKeys) {
        tableName = tableName.trim();
        DialectUtils.trimPrimaryKeys(pKeys);
        StringBuilder sql = new StringBuilder("delete from ");
        if (tableName.contains(".")) {
            sql.append(tableName);
        } else {
            sql.append("`").append(tableName).append("`");
        }
        sql.append(" where ");
        for (int i = 0; i < pKeys.length; ++i) {
            if (i > 0) {
                sql.append(" and ");
            }
            sql.append('`').append(pKeys[i]).append("` = ?");
        }
        return sql.toString();
    }

    @Override
    public String forDbDeleteByField(String tableName, String field) {
        StringBuilder sql = new StringBuilder(45);
        sql.append("delete from ");
        if (tableName.contains(".")) {
            sql.append(tableName);
        } else {
            sql.append("`").append(tableName).append("`");
        }
        sql.append(" where ");
        sql.append('`').append(field).append("` = ?");
        return sql.toString();
    }

    @Override
    public void forDbSave(String tableName, String[] pKeys, Row record, StringBuilder sql, List<Object> paras) {
        tableName = tableName.trim();
        DialectUtils.trimPrimaryKeys(pKeys);
        if (tableName.contains(".")) {
            sql.append("insert into ").append(tableName).append("(");
        } else {
            sql.append("insert into `").append(tableName).append("`(");
        }
        StringBuilder temp = new StringBuilder();
        temp.append(") values(");
        for (Map.Entry<String, Object> e : record.getColumns().entrySet()) {
            if (paras.size() > 0) {
                sql.append(", ");
                temp.append(", ");
            }
            sql.append('`').append(e.getKey()).append('`');
            temp.append('?');
            paras.add(e.getValue());
        }
        sql.append(temp.toString()).append(')');
    }

    @Override
    public StringBuffer forDbFind(String tableName, String columns, Row record, List<Object> paras) {
        StringBuffer sql = new StringBuffer();
        tableName = tableName.trim();
        sql.append("select ").append(columns).append(" from ");
        if (tableName.contains(".")) {
            sql.append(tableName);
        } else {
            sql.append("`").append(tableName).append("`");
        }
        if (!record.getColumns().isEmpty()) {
            sql.append(" where ");
            boolean first = true;
            for (Map.Entry<String, Object> e : record.getColumns().entrySet()) {
                if (!first) {
                    sql.append(" and ");
                } else {
                    first = false;
                }
                sql.append('`').append(e.getKey()).append("` = ?");
                paras.add(e.getValue());
            }
        }
        return sql;
    }

    @Override
    public StringBuffer forDbFindByField(String tableName, String columns, String field, Object fieldValue, List<Object> paras) {
        StringBuffer sql = new StringBuffer();
        tableName = tableName.trim();
        sql.append("select ").append(columns).append(" from ");
        if (tableName.contains(".")) {
            sql.append(tableName);
        } else {
            sql.append("`").append(tableName).append("`");
        }
        if (field != null && !field.isEmpty()) {
            sql.append(" where ");
            sql.append('`').append(field).append("` = ?");
            paras.add(fieldValue);
        }
        return sql;
    }

    @Override
    public void forDbDelete(String tableName, String[] pKeys, Row record, StringBuilder sql, List<Object> paras) {
        DialectUtils.forDbDelete(tableName, pKeys, record, sql, paras);
    }

    @Override
    public void forDbUpdate(String tableName, String[] pKeys, Object[] ids, Row record, StringBuilder sql, List<Object> paras) {
        tableName = tableName.trim();
        DialectUtils.trimPrimaryKeys(pKeys);
        Set<String> modifyFlag = CPI.getModifyFlag(record);
        if (tableName.contains(".")) {
            sql.append("update ").append(tableName).append(" set ");
        } else {
            sql.append("update `").append(tableName).append("` set ");
        }
        for (Map.Entry<String, Object> e : record.getColumns().entrySet()) {
            String colName = e.getKey();
            if (!modifyFlag.contains(colName) || this.isPrimaryKey(colName, pKeys)) continue;
            if (paras.size() > 0) {
                sql.append(", ");
            }
            sql.append('`').append(colName).append("` = ? ");
            paras.add(e.getValue());
        }
        sql.append(" where ");
        for (int i = 0; i < pKeys.length; ++i) {
            if (i > 0) {
                sql.append(" and ");
            }
            sql.append('`').append(pKeys[i]).append("` = ?");
            paras.add(ids[i]);
        }
    }

    @Override
    public String forPaginate(int pageNumber, int pageSize, StringBuilder findSql) {
        int offset = pageSize * (pageNumber - 1);
        findSql.append(" limit ").append(offset).append(", ").append(pageSize);
        return findSql.toString();
    }

    @Override
    public String forDbFindColumnsById(String tableName, String columns, String[] pKeys) {
        return DialectUtils.forDbFindColumnsById(tableName, columns, pKeys);
    }

    @Override
    public String forDbFindColumns(String tableName, String columns) {
        return DialectUtils.forDbFindColumns(tableName, columns);
    }

    @Override
    public String forExistsByFields(String tableName, String fields) {
        return DialectUtils.forExistsByFields(tableName, fields);
    }

    @Override
    public void forDbUpdate(String tableName, String[] pKeys, Object[] ids, Row record, StringBuilder sql, List<Object> paras, String[] jsonFields) {
        if (jsonFields != null) {
            for (String f : jsonFields) {
                record.set(f, Json.getJson().toJson(record.get(f)));
            }
        }
        this.forDbUpdate(tableName, pKeys, ids, record, sql, paras);
    }

    @Override
    public void transformJsonFields(Row record, String[] jsonFields) {
        if (jsonFields != null) {
            for (String f : jsonFields) {
                Object object = record.get(f);
                if (object == null) continue;
                String value = Json.getJson().toJson(object);
                record.set(f, value);
            }
        }
    }

    @Override
    public void transformJsonFields(List<Row> recordList, String[] jsonFields) {
        if (jsonFields != null && jsonFields.length > 0) {
            for (String f : jsonFields) {
                for (Row record : recordList) {
                    Object object = record.get(f);
                    if (object == null) continue;
                    String value = Json.getJson().toJson(object);
                    record.set(f, value);
                }
            }
        }
    }

    @Override
    public void fillPst(PreparedStatement pst, int i, Object value) throws SQLException {
        if (value instanceof String) {
            pst.setString(i + 1, (String)value);
        } else if (value instanceof java.util.Date) {
            if (value instanceof Date) {
                pst.setDate(i + 1, (Date)value);
            } else if (value instanceof Timestamp) {
                pst.setTimestamp(i + 1, (Timestamp)value);
            } else {
                java.util.Date d = (java.util.Date)value;
                pst.setTimestamp(i + 1, new Timestamp(d.getTime()));
            }
        } else if (value instanceof Long) {
            pst.setLong(i + 1, (Long)value);
        } else if (value instanceof Integer) {
            pst.setInt(i + 1, (Integer)value);
        } else if (value instanceof Short) {
            pst.setShort(i + 1, (Short)value);
        } else if (value instanceof Byte) {
            pst.setByte(i + 1, (Byte)value);
        } else if (value instanceof Double) {
            pst.setDouble(i + 1, (Double)value);
        } else if (value instanceof Float) {
            pst.setFloat(i + 1, ((Float)value).floatValue());
        } else if (value instanceof BigDecimal) {
            pst.setBigDecimal(i + 1, (BigDecimal)value);
        } else if (value instanceof Boolean) {
            pst.setBoolean(i + 1, (Boolean)value);
        } else if (value instanceof LocalDate) {
            pst.setDate(i + 1, Date.valueOf((LocalDate)value));
        } else if (value instanceof LocalDateTime) {
            pst.setTimestamp(i + 1, Timestamp.valueOf((LocalDateTime)value));
        } else if (value instanceof byte[]) {
            pst.setBytes(i + 1, (byte[])value);
        } else if (value instanceof UUID) {
            pst.setObject(i + 1, value, 1111);
        } else if (value instanceof Enum) {
            pst.setString(i + 1, ((Enum)value).name());
        } else if (value instanceof List) {
            Array sqlArray = pst.getConnection().createArrayOf("text", ((List)value).toArray());
            pst.setArray(i + 1, sqlArray);
        } else {
            String json = JsonUtils.toJson((Object)value);
            pst.setObject(i + 1, json);
        }
    }

    @Override
    public String forColumns(String columns) {
        return DialectUtils.forColumns(columns);
    }
}

