/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.db.utils;

import com.litongjava.db.activerecord.Row;
import com.litongjava.kit.RowUtils;
import java.util.List;

public class HtmlTableUtils {
    public static String to(List<Row> records) {
        String[] head = null;
        int size = records.size();
        if (size <= 0) {
            return null;
        }
        Row record = records.get(0);
        head = record.getColumnNames();
        List<List<Object>> body = RowUtils.getListData(records, size);
        return HtmlTableUtils.toHtmlTable(head, body);
    }

    public static String toHtmlTable(String[] head, List<List<Object>> body) {
        StringBuilder table = new StringBuilder();
        table.append("<table border=\"1\">\n");
        table.append("  <thead>\n");
        table.append("    <tr>\n");
        for (String column : head) {
            table.append("      <th>").append(HtmlTableUtils.escapeHtml(column)).append("</th>\n");
        }
        table.append("    </tr>\n");
        table.append("  </thead>\n");
        table.append("  <tbody>\n");
        for (List list : body) {
            table.append("    <tr>\n");
            for (Object cell : list) {
                table.append("      <td>");
                if (cell != null) {
                    table.append(HtmlTableUtils.escapeHtml(cell.toString()));
                } else {
                    table.append("NULL");
                }
                table.append("</td>\n");
            }
            table.append("    </tr>\n");
        }
        table.append("  </tbody>\n");
        table.append("</table>");
        return table.toString();
    }

    private static String escapeHtml(String text) {
        if (text == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        block7: for (char c : text.toCharArray()) {
            switch (c) {
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    sb.append("&#39;");
                    continue block7;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }
}

