/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.db.utils;

import com.litongjava.db.activerecord.Row;
import com.litongjava.kit.RowUtils;
import java.util.List;
import java.util.Map;

public class MarkdownTableUtils {
    public static String to(List<Row> records) {
        String[] head = null;
        int size = records.size();
        if (size <= 0) {
            return null;
        }
        Row record = records.get(0);
        head = record.getColumnNames();
        List<List<Object>> body = RowUtils.getListData(records, size);
        return MarkdownTableUtils.toMarkdownTable(head, body);
    }

    public static String toMarkdownTable(String[] head, List<List<Object>> body) {
        StringBuilder table = new StringBuilder();
        table.append("| ");
        for (String column : head) {
            table.append(column).append(" | ");
        }
        table.append("\n");
        table.append("| ");
        for (int i = 0; i < head.length; ++i) {
            table.append("--- | ");
        }
        table.append("\n");
        for (List<Object> row : body) {
            table.append("| ");
            for (Object cell : row) {
                if (cell != null) {
                    table.append(cell.toString()).append(" | ");
                    continue;
                }
                table.append("NULL").append(" | ");
            }
            table.append("\n");
        }
        return table.toString();
    }

    public static String toItems(Row row) {
        if (row == null) {
            return "";
        }
        StringBuilder markdownList = new StringBuilder();
        String[] columns = row.getColumnNames();
        Map<String, Object> dataMap = row.toMap();
        for (String column : columns) {
            Object value = dataMap.get(column);
            if (value != null) {
                markdownList.append("- ").append(column).append(": ").append(value.toString()).append("\n");
                continue;
            }
            markdownList.append("- ").append(column).append(": NULL\n");
        }
        return markdownList.toString();
    }
}

