/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.template;

import com.litongjava.tio.utils.hutool.ResourceUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlTemplates {
    private static final Logger log = LoggerFactory.getLogger(SqlTemplates.class);
    public static final String DEFAULT_MAIN_FILE = "sql-templates/main.sql";
    public static final String DEFAULT_SQL_DIR = "sql-templates";
    private static Map<String, String> sqlTemplates = null;
    private static boolean loaded = false;
    private static final Pattern INCLUDE_PATTERN = Pattern.compile("--#include\\((.*?)\\)");

    public static synchronized void load(String mainFilePath) {
        if (loaded) {
            return;
        }
        sqlTemplates = new HashMap<String, String>();
        File file = new File(mainFilePath);
        try {
            URL fileUrl = file.toURI().toURL();
            SqlTemplates.parseSQLFile(fileUrl, true);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        loaded = true;
    }

    public static synchronized void load() {
        if (loaded) {
            return;
        }
        sqlTemplates = new HashMap<String, String>();
        URL mainFileUrl = ResourceUtil.getResource((String)DEFAULT_MAIN_FILE);
        if (mainFileUrl != null) {
            log.info("Loading SQL templates from main file: {}", (Object)DEFAULT_MAIN_FILE);
            SqlTemplates.parseSQLFile(mainFileUrl, true);
        } else {
            log.info("{} not found. Scanning directory: {}", (Object)DEFAULT_MAIN_FILE, (Object)DEFAULT_SQL_DIR);
            URL dirUrl = ResourceUtil.getResource((String)DEFAULT_SQL_DIR);
            if (dirUrl == null) {
                log.warn("SQL template directory not found: {}", (Object)DEFAULT_SQL_DIR);
                loaded = true;
                return;
            }
            List listResources = ResourceUtil.listResources((String)DEFAULT_SQL_DIR, (String)".sql");
            if (listResources.size() > 0) {
                for (URL sqlFile : listResources) {
                    log.info("Loading SQL templates from file: {}", (Object)sqlFile);
                    SqlTemplates.parseSQLFile(sqlFile, false);
                }
            } else {
                log.warn("not found SQL in  directory:{}", (Object)DEFAULT_SQL_DIR);
            }
        }
        loaded = true;
    }

    private static void parseSQLFile(URL resource, boolean allowInclude) {
        if (resource == null) {
            throw new RuntimeException("SQL file not found");
        }
        String filePath = resource.getFile();
        try (InputStream inputStream = resource.openStream();
             BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            String currentID = null;
            StringBuilder sqlBuilder = new StringBuilder();
            String line = reader.readLine();
            while (line != null) {
                String[] parts;
                String trimmedLine = line.trim();
                if (trimmedLine.startsWith("--#") && !trimmedLine.startsWith("--#include")) {
                    if (currentID != null && sqlBuilder.length() > 0) {
                        sqlTemplates.put(currentID, sqlBuilder.toString());
                    }
                    if ((parts = trimmedLine.split("\\s+", 2)).length > 1) {
                        currentID = parts[1];
                        sqlBuilder = new StringBuilder();
                        if (sqlTemplates.containsKey(currentID)) {
                            log.warn("Duplicate SQL ID found: {}. It will be overwritten by content in file: {}", (Object)currentID, (Object)filePath);
                        }
                    } else {
                        currentID = null;
                    }
                } else if (allowInclude && trimmedLine.startsWith("--@")) {
                    if (currentID != null && sqlBuilder.length() > 0) {
                        sqlTemplates.put(currentID, sqlBuilder.toString());
                    }
                    currentID = null;
                    sqlBuilder = new StringBuilder();
                    parts = trimmedLine.split("\\s+", 2);
                    if (parts.length > 1) {
                        String parentPath = SqlTemplates.getParentPath(filePath);
                        String includedFilePath = parentPath.isEmpty() ? parts[1] : parentPath + "/" + parts[1];
                        URL url = new File(includedFilePath).toURI().toURL();
                        SqlTemplates.parseSQLFile(url, true);
                    }
                } else if (currentID != null) {
                    sqlBuilder.append(line).append(System.lineSeparator());
                }
                line = reader.readLine();
            }
            if (currentID != null && sqlBuilder.length() > 0) {
                sqlTemplates.put(currentID, sqlBuilder.toString());
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read SQL file: " + filePath, e);
        }
    }

    public static String get(String sqlId) throws IllegalArgumentException {
        if (!loaded) {
            SqlTemplates.load();
        }
        return SqlTemplates.get(sqlId, new HashSet<String>());
    }

    private static String get(String sqlId, Set<String> processingIds) {
        String rawSql = sqlTemplates.get(sqlId);
        if (rawSql == null) {
            log.error("SQL ID not found: '{}'. Available IDs are: {}", (Object)sqlId, sqlTemplates.keySet());
            throw new IllegalArgumentException("SQL ID not found: " + sqlId);
        }
        if (!processingIds.add(sqlId)) {
            throw new IllegalStateException("Circular SQL inclusion detected: " + String.join((CharSequence)" -> ", processingIds) + " -> " + sqlId);
        }
        Matcher matcher = INCLUDE_PATTERN.matcher(rawSql);
        StringBuffer finalSql = new StringBuffer();
        while (matcher.find()) {
            String includedId = matcher.group(1).trim();
            String includedSql = SqlTemplates.get(includedId, processingIds);
            matcher.appendReplacement(finalSql, Matcher.quoteReplacement(includedSql));
        }
        matcher.appendTail(finalSql);
        processingIds.remove(sqlId);
        return finalSql.toString().trim();
    }

    public static Map<String, String> getAll() {
        if (!loaded) {
            SqlTemplates.load();
        }
        return Collections.unmodifiableMap(sqlTemplates);
    }

    public static synchronized void reset() {
        loaded = false;
        sqlTemplates = null;
    }

    private static String getParentPath(String resourcePath) {
        int lastSlash = resourcePath.lastIndexOf(47);
        if (lastSlash == -1) {
            return "";
        }
        return resourcePath.substring(0, lastSlash);
    }
}

