/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.db.activerecord.generator;

import com.jfinal.kit.JavaKeyword;
import com.jfinal.kit.Kv;
import com.jfinal.kit.StrKit;
import com.jfinal.template.Engine;
import com.litongjava.db.activerecord.generator.TableMeta;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;
import java.util.Map;

public class ModelGenerator {
    protected Engine engine;
    protected String template = "/com/litongjava/db/activerecord/generator/model_template.jf";
    protected String modelPackageName;
    protected String baseModelPackageName;
    protected String modelOutputDir;
    protected boolean generateDaoInModel = false;
    protected JavaKeyword javaKeyword = JavaKeyword.me;

    public ModelGenerator(String modelPackageName, String baseModelPackageName, String modelOutputDir) {
        if (StrKit.isBlank((String)modelPackageName)) {
            throw new IllegalArgumentException("modelPackageName can not be blank.");
        }
        if (modelPackageName.contains("/") || modelPackageName.contains("\\")) {
            throw new IllegalArgumentException("modelPackageName error : " + modelPackageName);
        }
        if (StrKit.isBlank((String)baseModelPackageName)) {
            throw new IllegalArgumentException("baseModelPackageName can not be blank.");
        }
        if (baseModelPackageName.contains("/") || baseModelPackageName.contains("\\")) {
            throw new IllegalArgumentException("baseModelPackageName error : " + baseModelPackageName);
        }
        if (StrKit.isBlank((String)modelOutputDir)) {
            throw new IllegalArgumentException("modelOutputDir can not be blank.");
        }
        this.modelPackageName = modelPackageName;
        this.baseModelPackageName = baseModelPackageName;
        this.modelOutputDir = modelOutputDir;
        this.initEngine();
    }

    protected void initEngine() {
        this.engine = new Engine();
        this.engine.setToClassPathSourceFactory();
        this.engine.addSharedMethod((Object)new StrKit());
        this.engine.addSharedObject("javaKeyword", (Object)this.javaKeyword);
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public void setGenerateDaoInModel(boolean generateDaoInModel) {
        this.generateDaoInModel = generateDaoInModel;
    }

    public void generate(List<TableMeta> tableMetas) {
        System.out.println("Generate model ...");
        System.out.println("Model Output Dir: " + this.modelOutputDir);
        for (TableMeta tableMeta : tableMetas) {
            this.genModelContent(tableMeta);
        }
        this.writeToFile(tableMetas);
    }

    protected void genModelContent(TableMeta tableMeta) {
        String ret;
        Kv data = Kv.by((Object)"modelPackageName", (Object)this.modelPackageName);
        data.set((Object)"baseModelPackageName", (Object)this.baseModelPackageName);
        data.set((Object)"generateDaoInModel", (Object)this.generateDaoInModel);
        data.set((Object)"tableMeta", (Object)tableMeta);
        tableMeta.modelContent = ret = this.engine.getTemplate(this.template).renderToString((Map)data);
    }

    protected void writeToFile(List<TableMeta> tableMetas) {
        try {
            for (TableMeta tableMeta : tableMetas) {
                this.writeToFile(tableMeta);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void writeToFile(TableMeta tableMeta) throws IOException {
        File dir = new File(this.modelOutputDir);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        String target = this.modelOutputDir + File.separator + tableMeta.modelName + ".java";
        File file = new File(target);
        try (OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");){
            osw.write(tableMeta.modelContent);
        }
    }

    public String getModelPackageName() {
        return this.modelPackageName;
    }

    public String getBaseModelPackageName() {
        return this.baseModelPackageName;
    }

    public String getModelOutputDir() {
        return this.modelOutputDir;
    }
}

