/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.db.base;

import com.litongjava.db.SqlPara;
import com.litongjava.db.activerecord.Db;
import com.litongjava.db.activerecord.Row;
import com.litongjava.model.page.Page;
import java.util.List;
import org.postgresql.util.PGobject;

public abstract class DbBase {
    public abstract String getTableName();

    public boolean save(Row record) {
        return Db.save(this.getTableName(), record);
    }

    public boolean save(String primaryKey, Row record) {
        return Db.save(this.getTableName(), primaryKey, record);
    }

    public boolean saveIfAbsent(Row record) {
        return Db.saveIfAbset(this.getTableName(), record);
    }

    public boolean save(Row record, String[] jsonFields) {
        return Db.save(this.getTableName(), record, jsonFields);
    }

    public boolean save(String primaryKey, Row record, String[] jsonFields) {
        return Db.save(this.getTableName(), primaryKey, record, jsonFields);
    }

    public boolean update(Row record) {
        return Db.update(this.getTableName(), record);
    }

    public boolean update(String primaryKeys, Row record) {
        return Db.update(this.getTableName(), primaryKeys, record);
    }

    public boolean update(String primaryKey, Row record, String[] jsonFields) {
        return Db.update(this.getTableName(), primaryKey, record, jsonFields);
    }

    public boolean deleteById(Object idValue) {
        return Db.deleteById(this.getTableName(), idValue);
    }

    public boolean deleteById(String primaryKey, Object idValue) {
        return Db.deleteById(this.getTableName(), primaryKey, idValue);
    }

    public boolean deleteByIds(String primaryKey, Object ... idValues) {
        return Db.deleteByIds(this.getTableName(), primaryKey, idValues);
    }

    public boolean delete(Row record) {
        return Db.delete(this.getTableName(), record);
    }

    public boolean delete(String primaryKey, Row record) {
        return Db.delete(this.getTableName(), primaryKey, record);
    }

    public boolean deleteByIds(Row record) {
        return Db.deleteByIds(this.getTableName(), record);
    }

    public <T> T queryColumnById(String column, Object id) {
        return Db.queryColumnById(this.getTableName(), column, id);
    }

    public Long queryLongById(String column, Object id) {
        return Db.queryLongById(this.getTableName(), column, id);
    }

    public Long queryStrById(String column, Object id) {
        return Db.queryStrById(this.getTableName(), column, id);
    }

    public <T> T queryColumnByField(String column, String field, Object value) {
        return Db.queryColumnByField(this.getTableName(), column, field, value);
    }

    public PGobject queryPGobjectById(String column, Object id) {
        return Db.queryPGobjectById(this.getTableName(), column, id);
    }

    public List<Row> find(Row where) {
        return Db.find(this.getTableName(), where);
    }

    public List<Row> find(String columns, Row where) {
        return Db.find(this.getTableName(), columns, where);
    }

    public List<Row> findByField(String field, Object value) {
        return Db.findByField(this.getTableName(), field, value);
    }

    public List<Row> findIn(String primaryKey, Object ... ids) {
        return Db.findIn(this.getTableName(), primaryKey, ids);
    }

    public List<Row> findColumnsIn(String columns, String primaryKey, Object ... ids) {
        return Db.findColumnsIn(this.getTableName(), columns, primaryKey, ids);
    }

    public List<Row> findColumnsIn(String columns, String primaryKey, List<?> ids) {
        return Db.findColumnsIn(this.getTableName(), columns, primaryKey, ids);
    }

    public List<Row> findAll() {
        return Db.findAll(this.getTableName());
    }

    public List<Row> findColumns(String columns) {
        return Db.findColumns(this.getTableName(), columns);
    }

    public Row findFirst(Row where) {
        return Db.findFirst(this.getTableName(), where);
    }

    public Row findFirst(String columns, Row where) {
        return Db.findFirst(this.getTableName(), columns, where);
    }

    public Row findOne() {
        return Db.findOne(this.getTableName());
    }

    public Row findById(Object id) {
        return Db.findById(this.getTableName(), id);
    }

    public Row findById(String primaryKey, Object id) {
        return Db.findById(this.getTableName(), primaryKey, id);
    }

    public <T> T findById(Class<T> clazz, Object id) {
        return Db.findById(clazz, this.getTableName(), id);
    }

    public <T> T findById(Class<T> clazz, String primaryKey, Object id) {
        return Db.findById(clazz, this.getTableName(), primaryKey, id);
    }

    public Row findColumnsById(String columns, Object id) {
        return Db.findColumnsById(this.getTableName(), columns, id);
    }

    public Row findColumnsById(String columns, String primaryKey, Object id) {
        return Db.findColumnsById(this.getTableName(), columns, primaryKey, id);
    }

    public Row findByIds(String primaryKey, Object ... ids) {
        return Db.findByIds(this.getTableName(), primaryKey, ids);
    }

    public <T> T findByIds(Class<T> clazz, String primaryKey, Object ... ids) {
        return Db.findByIds(clazz, this.getTableName(), primaryKey, ids);
    }

    public Row findColumnsByIds(String columns, String primaryKey, Object ... ids) {
        return Db.findColumnsByIds(this.getTableName(), columns, primaryKey, ids);
    }

    public List<Row> findByColumn(String column, Object value) {
        return Db.findByColumn(this.getTableName(), column, value);
    }

    public boolean exists(String fields, Object ... paras) {
        return Db.exists(this.getTableName(), fields, paras);
    }

    public Long count() {
        return Db.countTable(this.getTableName());
    }

    public Page<Row> paginate(int pageNumber, int pageSize, SqlPara sqlPara) {
        return Db.paginate(pageNumber, pageSize, sqlPara);
    }

    public Page<Row> paginate(int pageNumber, int pageSize, boolean isGroupBySql, SqlPara sqlPara) {
        return Db.paginate(pageNumber, pageSize, isGroupBySql, sqlPara);
    }

    public Page<Row> paginate(int pageNumber, int pageSize, String select, String sqlExceptSelect, Object ... paras) {
        return Db.paginate(pageNumber, pageSize, select, sqlExceptSelect, paras);
    }

    public Page<Row> paginate(int pageNumber, int pageSize, String select, String sqlExceptSelect) {
        return Db.paginate(pageNumber, pageSize, select, sqlExceptSelect);
    }

    public List<Row> findByTemplate(String key, Object ... paras) {
        return Db.template(key, paras).find();
    }

    public Row findFirstByTemplate(String key, Object ... paras) {
        return Db.template(key, paras).findFirst();
    }

    public Page<Row> paginateByTemplate(int pageNumber, int pageSize, String key, Object ... paras) {
        return Db.template(key, paras).paginate(pageNumber, pageSize);
    }
}

