/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.chat;

import com.litongjava.chat.ChatFile;
import com.litongjava.chat.ChatMessageArgs;
import java.util.List;

public class UniChatMessage {
    private String role = "user";
    private String content;
    private List<ChatFile> files;
    private ChatMessageArgs args;

    public UniChatMessage(String role, String content) {
        this.role = role;
        this.content = content;
    }

    public UniChatMessage(String role, String content, ChatMessageArgs args) {
        this.role = role;
        this.content = content;
        this.args = args;
    }

    public static UniChatMessage buildSystem(String content) {
        return new UniChatMessage("system", content);
    }

    public static UniChatMessage buildUser(String content) {
        return new UniChatMessage("user", content);
    }

    public static UniChatMessage buildAssistant(String content) {
        return new UniChatMessage("assistant", content);
    }

    public UniChatMessage role(String role) {
        this.role = role;
        return this;
    }

    public UniChatMessage content(String content) {
        this.content = content;
        return this;
    }

    public UniChatMessage(String content) {
        this.role = "user";
        this.content = content;
    }

    public String getRole() {
        return this.role;
    }

    public String getContent() {
        return this.content;
    }

    public List<ChatFile> getFiles() {
        return this.files;
    }

    public ChatMessageArgs getArgs() {
        return this.args;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setFiles(List<ChatFile> files) {
        this.files = files;
    }

    public void setArgs(ChatMessageArgs args) {
        this.args = args;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UniChatMessage)) {
            return false;
        }
        UniChatMessage other = (UniChatMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$role = this.getRole();
        String other$role = other.getRole();
        if (this$role == null ? other$role != null : !this$role.equals(other$role)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        List<ChatFile> this$files = this.getFiles();
        List<ChatFile> other$files = other.getFiles();
        if (this$files == null ? other$files != null : !((Object)this$files).equals(other$files)) {
            return false;
        }
        ChatMessageArgs this$args = this.getArgs();
        ChatMessageArgs other$args = other.getArgs();
        return !(this$args == null ? other$args != null : !((Object)this$args).equals(other$args));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UniChatMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $role = this.getRole();
        result = result * 59 + ($role == null ? 43 : $role.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        List<ChatFile> $files = this.getFiles();
        result = result * 59 + ($files == null ? 43 : ((Object)$files).hashCode());
        ChatMessageArgs $args = this.getArgs();
        result = result * 59 + ($args == null ? 43 : ((Object)$args).hashCode());
        return result;
    }

    public String toString() {
        return "UniChatMessage(role=" + this.getRole() + ", content=" + this.getContent() + ", files=" + this.getFiles() + ", args=" + this.getArgs() + ")";
    }

    public UniChatMessage() {
    }

    public UniChatMessage(String role, String content, List<ChatFile> files, ChatMessageArgs args) {
        this.role = role;
        this.content = content;
        this.files = files;
        this.args = args;
    }
}

