/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.gemini;

import com.litongjava.chat.ChatFile;
import com.litongjava.chat.UniChatMessage;
import com.litongjava.gemini.GeminiPartVo;
import com.litongjava.tio.utils.hutool.StrUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class GeminiContentVo {
    private String role;
    private List<GeminiPartVo> parts;

    public GeminiContentVo(UniChatMessage chatMessage) {
        this.role = chatMessage.getRole();
        this.parts = Collections.singletonList(new GeminiPartVo(chatMessage.getContent()));
    }

    public GeminiContentVo(String role, String content) {
        this.role = role;
        this.parts = Collections.singletonList(new GeminiPartVo(content));
    }

    public GeminiContentVo(String role, UniChatMessage chatMessage) {
        List<ChatFile> files;
        this.role = role;
        String content = chatMessage.getContent();
        ArrayList<GeminiPartVo> parts = new ArrayList<GeminiPartVo>();
        if (StrUtil.isNotBlank((CharSequence)content)) {
            GeminiPartVo geminiPartVo = new GeminiPartVo(content);
            parts.add(geminiPartVo);
        }
        if ((files = chatMessage.getFiles()) != null) {
            for (ChatFile chatFile : files) {
                parts.add(new GeminiPartVo(chatFile));
            }
        }
        this.parts = parts;
    }

    public String getRole() {
        return this.role;
    }

    public List<GeminiPartVo> getParts() {
        return this.parts;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public void setParts(List<GeminiPartVo> parts) {
        this.parts = parts;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GeminiContentVo)) {
            return false;
        }
        GeminiContentVo other = (GeminiContentVo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$role = this.getRole();
        String other$role = other.getRole();
        if (this$role == null ? other$role != null : !this$role.equals(other$role)) {
            return false;
        }
        List<GeminiPartVo> this$parts = this.getParts();
        List<GeminiPartVo> other$parts = other.getParts();
        return !(this$parts == null ? other$parts != null : !((Object)this$parts).equals(other$parts));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GeminiContentVo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $role = this.getRole();
        result = result * 59 + ($role == null ? 43 : $role.hashCode());
        List<GeminiPartVo> $parts = this.getParts();
        result = result * 59 + ($parts == null ? 43 : ((Object)$parts).hashCode());
        return result;
    }

    public String toString() {
        return "GeminiContentVo(role=" + this.getRole() + ", parts=" + this.getParts() + ")";
    }

    public GeminiContentVo() {
    }

    public GeminiContentVo(String role, List<GeminiPartVo> parts) {
        this.role = role;
        this.parts = parts;
    }
}

