/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.jian.search;

import com.litongjava.jian.search.JinaSearchRequest;
import com.litongjava.model.http.response.ResponseVo;
import com.litongjava.model.web.WebPageContent;
import com.litongjava.tio.utils.environment.EnvUtils;
import com.litongjava.tio.utils.http.OkHttpClientPool;
import com.litongjava.tio.utils.json.JsonUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JinaSearchClient {
    private static final Logger log = LoggerFactory.getLogger(JinaSearchClient.class);
    private static final OkHttpClient client = OkHttpClientPool.get120HttpClient();
    public static String regex = "\\[(\\d+)\\] Title: (.*?)\n\\[\\d+\\] URL Source: (.*?)\n\\[\\d+\\] Description: (.*?)(?=\\[\\d+\\] Markdown Content:|\n\\[\\d+\\]|$)(?:\\[\\d+\\] Markdown Content:\n(.*?))?(?=\n\\[\\d+\\] Title: |$)";
    public static Pattern sourcePattern = Pattern.compile(regex, 32);

    public static ResponseVo search(JinaSearchRequest request) {
        String endpoint = request.getEndpoint() == null ? "https://s.jina.ai/" : request.getEndpoint();
        String method = request.getMethod() == null ? "POST" : request.getMethod();
        ResponseVo responseVo = new ResponseVo();
        try {
            RequestBody body = null;
            if ("POST".equalsIgnoreCase(method) || "PUT".equalsIgnoreCase(method)) {
                HashMap<String, String> reqBody = new HashMap<String, String>();
                if (request.getQ() != null) {
                    reqBody.put("q", request.getQ());
                }
                if (request.getCount() != null) {
                    reqBody.put("count", request.getCount());
                }
                String json = JsonUtils.toJson(reqBody);
                MediaType mediaType = MediaType.parse((String)(request.getContentType() != null ? request.getContentType() : "application/json; charset=utf-8"));
                body = RequestBody.create((String)json, (MediaType)mediaType);
            }
            Request.Builder builder = new Request.Builder().url(endpoint);
            if (request.getAuthorization() != null) {
                builder.header("Authorization", "Bearer " + request.getAuthorization());
            } else {
                String key = EnvUtils.getStr((String)"JINA_API_KEY");
                if (key == null) {
                    responseVo.setOk(false);
                    responseVo.setBodyString("JINA_API_KEY is null");
                    return responseVo;
                }
                builder.header("Authorization", "Bearer " + key);
            }
            if (request.getContentType() != null) {
                builder.header("Content-Type", request.getContentType());
            }
            if (request.getXRetainImages() != null) {
                builder.header("X-Retain-Images", request.getXRetainImages());
            }
            if (request.getXSite() != null) {
                builder.header("X-Site", request.getXSite());
            }
            if (request.getXWithGeneratedAlt() != null) {
                builder.header("X-With-Generated-Alt", request.getXWithGeneratedAlt());
            }
            if (request.getXWithLinksSummary() != null) {
                builder.header("X-With-Links-Summary", request.getXWithLinksSummary());
            }
            switch (method.toUpperCase()) {
                case "POST": {
                    builder.post(body != null ? body : RequestBody.create((String)"", null));
                    break;
                }
                case "PUT": {
                    builder.put(body != null ? body : RequestBody.create((String)"", null));
                    break;
                }
                case "DELETE": {
                    builder.delete();
                    break;
                }
                default: {
                    builder.get();
                }
            }
            Request okHttpRequest = builder.build();
            try (Response response = client.newCall(okHttpRequest).execute();){
                int code = response.code();
                responseVo.setCode(code);
                responseVo.setOk(code >= 200 && code < 300);
                ResponseBody responseBody = response.body();
                String bodyString = responseBody == null ? "" : responseBody.string();
                responseVo.setBodyString(bodyString);
                HashMap<String, String> headersMap = new HashMap<String, String>();
                Headers headers = response.headers();
                for (String name : headers.names()) {
                    headersMap.put(name, headers.get(name));
                }
                responseVo.setHeadersMap(headersMap);
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            responseVo.setOk(false);
            responseVo.setBodyString(e.getMessage());
        }
        return responseVo;
    }

    public static String search(String keywords) {
        JinaSearchRequest jinaSearchRequest = new JinaSearchRequest();
        jinaSearchRequest.setQ(keywords);
        jinaSearchRequest.setXRetainImages("none");
        ResponseVo vo = JinaSearchClient.search(jinaSearchRequest);
        String bodyString = vo.getBodyString();
        if (vo.isOk()) {
            return bodyString;
        }
        int code = vo.getCode();
        throw new RuntimeException("code:" + code + " body:" + bodyString);
    }

    public static List<WebPageContent> parse(String markdown) {
        ArrayList<WebPageContent> results = new ArrayList<WebPageContent>();
        Matcher matcher = sourcePattern.matcher(markdown);
        while (matcher.find()) {
            String title = matcher.group(2).trim();
            String url = matcher.group(3).trim();
            String description = matcher.group(4) != null ? matcher.group(4).trim() : "";
            String content = matcher.group(5) != null ? matcher.group(5).trim() : "";
            WebPageContent webPageConteont = new WebPageContent(title, url, description, content);
            results.add(webPageConteont);
        }
        return results;
    }
}

