/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.minimax;

import com.litongjava.minimax.MiniMaxTTSRequest;
import com.litongjava.minimax.MiniMaxTTSResponse;
import com.litongjava.tio.utils.environment.EnvUtils;
import com.litongjava.tio.utils.http.OkHttpClientPool;
import com.litongjava.tio.utils.json.JsonUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class MiniMaxHttpClient {
    public static final String TTS_URL = "https://api.minimaxi.chat/v1";

    public static MiniMaxTTSResponse speech(String text, String voice) {
        MiniMaxTTSRequest miniMaxTTSRequest = new MiniMaxTTSRequest(text, voice);
        return MiniMaxHttpClient.speech(miniMaxTTSRequest);
    }

    public static MiniMaxTTSResponse speech(MiniMaxTTSRequest vo) {
        String groupId = EnvUtils.get((String)"MINIMAX_GROUP_ID");
        String apiKey = EnvUtils.get((String)"MINIMAX_API_KEY");
        return MiniMaxHttpClient.speech(groupId, apiKey, vo);
    }

    public static MiniMaxTTSResponse speech(String groupId, String apiKey, MiniMaxTTSRequest vo) {
        String apiPrefixUrl = EnvUtils.get((String)"FISHAUDIO_API_URL", (String)TTS_URL);
        return MiniMaxHttpClient.speech(apiPrefixUrl, groupId, apiKey, vo);
    }

    public static MiniMaxTTSResponse speech(String apiPrefixUrl, String groupId, String apiKey, MiniMaxTTSRequest vo) {
        String json = JsonUtils.toJson((Object)vo);
        return MiniMaxHttpClient.speechRequest(apiPrefixUrl, groupId, apiKey, json);
    }

    public static MiniMaxTTSResponse speechRequest(String apiPrefixUrl, String groupId, String apiKey, String payload) {
        String baseUrl = apiPrefixUrl + "/t2a_v2?GroupId=" + groupId;
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Authorization", "Bearer " + apiKey);
        return MiniMaxHttpClient.execute(baseUrl, header, payload);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static MiniMaxTTSResponse execute(String url, Map<String, String> header, String payload) {
        MediaType mediaType = MediaType.parse((String)"application/json");
        RequestBody body = RequestBody.create((String)payload, (MediaType)mediaType);
        Request.Builder requestBuilder = new Request.Builder().url(url).post(body);
        for (Map.Entry<String, String> entry : header.entrySet()) {
            requestBuilder.addHeader(entry.getKey(), entry.getValue());
        }
        Request request = requestBuilder.build();
        OkHttpClient httpClient = OkHttpClientPool.get300HttpClient();
        try (Response response = httpClient.newCall(request).execute();){
            int code = response.code();
            String responseBody = response.body().string();
            if (response.isSuccessful()) {
                MiniMaxTTSResponse miniMaxTTSResponse = (MiniMaxTTSResponse)JsonUtils.parse((String)responseBody, MiniMaxTTSResponse.class);
                return miniMaxTTSResponse;
            }
            throw new RuntimeException("Failed to tts code:" + code + " body: " + responseBody);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

