/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.openai.client;

import com.litongjava.exception.GenerateException;
import com.litongjava.openai.chat.ChatMessageContent;
import com.litongjava.openai.chat.OpenAiChatMessage;
import com.litongjava.openai.chat.OpenAiChatRequestVo;
import com.litongjava.openai.chat.OpenAiChatResponseVo;
import com.litongjava.openai.embedding.EmbeddingRequestVo;
import com.litongjava.openai.embedding.EmbeddingResponseVo;
import com.litongjava.tio.utils.environment.EnvUtils;
import com.litongjava.tio.utils.http.OkHttpClientPool;
import com.litongjava.tio.utils.hutool.StrUtil;
import com.litongjava.tio.utils.json.Json;
import com.litongjava.tio.utils.json.JsonUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;
import okhttp3.sse.EventSources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenAiClient {
    private static final Logger log = LoggerFactory.getLogger(OpenAiClient.class);
    public static boolean debug = false;
    public static final String OPENAI_API_URL = EnvUtils.get((String)"OPENAI_API_URL", (String)"https://api.openai.com/v1");

    public static Response chatCompletions(String apiKey, String bodyString) {
        HashMap<String, String> header = new HashMap<String, String>();
        if (StrUtil.isBlank((String)apiKey)) {
            throw new RuntimeException("api key can not empty");
        }
        header.put("Authorization", "Bearer " + apiKey);
        return OpenAiClient.chatCompletions(header, bodyString);
    }

    public static Response chatCompletions(Map<String, String> header, String bodyString) {
        return OpenAiClient.chatCompletions(OPENAI_API_URL, header, bodyString);
    }

    public static Response chatCompletions(String bodyString) {
        String apiKey = EnvUtils.get((String)"OPENAI_API_KEY");
        return OpenAiClient.chatCompletions(apiKey, bodyString);
    }

    public static Call chatCompletions(String bodyString, Callback callback) {
        HashMap<String, String> header = new HashMap<String, String>(1);
        String apiKey = EnvUtils.get((String)"OPENAI_API_KEY");
        if (StrUtil.isBlank((String)apiKey)) {
            throw new RuntimeException("api key can not empty");
        }
        header.put("Authorization", "Bearer " + apiKey);
        return OpenAiClient.chatCompletions(header, bodyString, callback);
    }

    public static EventSource chatCompletions(String bodyString, EventSourceListener listener) {
        HashMap<String, String> header = new HashMap<String, String>(1);
        String apiKey = EnvUtils.get((String)"OPENAI_API_KEY");
        if (StrUtil.isBlank((String)apiKey)) {
            throw new RuntimeException("api key can not empty");
        }
        header.put("Authorization", "Bearer " + apiKey);
        return OpenAiClient.chatCompletions(header, bodyString, listener);
    }

    public static Call chatCompletions(Map<String, String> header, String bodyString, Callback callback) {
        String apiPerfixUrl = EnvUtils.get((String)"OPENAI_API_URL", (String)"https://api.openai.com/v1");
        return OpenAiClient.chatCompletions(apiPerfixUrl, header, bodyString, callback);
    }

    public static EventSource chatCompletions(Map<String, String> header, String bodyString, EventSourceListener listener) {
        String apiPerfixUrl = EnvUtils.get((String)"OPENAI_API_URL", (String)"https://api.openai.com/v1");
        return OpenAiClient.chatCompletions(apiPerfixUrl, header, bodyString, listener);
    }

    public static OpenAiChatResponseVo chatCompletions(String model, OpenAiChatMessage chatMessage) {
        ArrayList<OpenAiChatMessage> messages = new ArrayList<OpenAiChatMessage>();
        messages.add(chatMessage);
        return OpenAiClient.chatCompletions(model, messages);
    }

    public static OpenAiChatResponseVo chatCompletions(String model, List<OpenAiChatMessage> messages) {
        OpenAiChatRequestVo chatRequestVo = new OpenAiChatRequestVo();
        chatRequestVo.setModel(model);
        chatRequestVo.setStream(false);
        chatRequestVo.setMessages(messages);
        return OpenAiClient.chatCompletions(chatRequestVo);
    }

    public static OpenAiChatResponseVo chatCompletions(String model, String systemPrompt, List<OpenAiChatMessage> messages) {
        messages.add(0, OpenAiChatMessage.buildSystem(systemPrompt));
        OpenAiChatRequestVo chatRequestVo = new OpenAiChatRequestVo();
        chatRequestVo.setModel(model);
        chatRequestVo.setStream(false);
        chatRequestVo.setMessages(messages);
        return OpenAiClient.chatCompletions(chatRequestVo);
    }

    public static OpenAiChatResponseVo chatCompletions(String apiKey, OpenAiChatRequestVo chatRequestVo) {
        OpenAiChatResponseVo respVo;
        block15: {
            String json = Json.getSkipNullJson().toJson((Object)chatRequestVo);
            respVo = null;
            try (Response response = OpenAiClient.chatCompletions(apiKey, json);){
                String bodyString = response.body().string();
                int code = response.code();
                if (response.isSuccessful()) {
                    respVo = (OpenAiChatResponseVo)JsonUtils.parse((String)bodyString, OpenAiChatResponseVo.class);
                    break block15;
                }
                throw new GenerateException("openai", "ChatGPT generateContent failed", OPENAI_API_URL, json, code, bodyString);
            }
            catch (IOException e) {
                log.error(e.getMessage() + " request json:" + json);
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return respVo;
    }

    public static OpenAiChatResponseVo chatCompletions(OpenAiChatRequestVo chatRequestVo) {
        String apiKey = EnvUtils.get((String)"OPENAI_API_KEY");
        return OpenAiClient.chatCompletions(apiKey, chatRequestVo);
    }

    public static Call chatCompletions(OpenAiChatRequestVo chatRequestVo, Callback callback) {
        String json = Json.getSkipNullJson().toJson((Object)chatRequestVo);
        return OpenAiClient.chatCompletions(json, callback);
    }

    public static EventSource chatCompletions(OpenAiChatRequestVo chatRequestVo, EventSourceListener listener) {
        String json = Json.getSkipNullJson().toJson((Object)chatRequestVo);
        return OpenAiClient.chatCompletions(json, listener);
    }

    public static OpenAiChatResponseVo chatCompletions(String apiPerfixUrl, String apiKey, OpenAiChatRequestVo chatRequestVo) {
        OpenAiChatResponseVo respVo;
        block16: {
            String json = Json.getSkipNullJson().toJson((Object)chatRequestVo);
            if (debug) {
                log.info("request json:{}", (Object)json);
            }
            respVo = null;
            try (Response response = OpenAiClient.chatCompletions(apiPerfixUrl, apiKey, json);){
                String bodyString = response.body().string();
                int code = response.code();
                if (response.isSuccessful()) {
                    respVo = (OpenAiChatResponseVo)JsonUtils.parse((String)bodyString, OpenAiChatResponseVo.class);
                    respVo.setRawResponse(bodyString);
                    break block16;
                }
                throw new GenerateException("openai", "LLM generated failed", apiPerfixUrl, json, code, bodyString);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return respVo;
    }

    public static Response chatCompletions(String apiPerfixUrl, String apiKey, String bodyString) {
        if (StrUtil.isBlank((String)apiKey)) {
            throw new RuntimeException("api key can not empty");
        }
        HashMap<String, String> header = new HashMap<String, String>(1);
        header.put("Authorization", "Bearer " + apiKey);
        return OpenAiClient.chatCompletions(apiPerfixUrl, header, bodyString);
    }

    public static Call chatCompletions(String apiPerfixUrl, String apiKey, String bodyString, Callback callback) {
        HashMap<String, String> header = new HashMap<String, String>(1);
        if (StrUtil.isBlank((String)apiKey)) {
            throw new RuntimeException("api key can not empty");
        }
        header.put("Authorization", "Bearer " + apiKey);
        return OpenAiClient.chatCompletions(apiPerfixUrl, header, bodyString, callback);
    }

    public static EventSource chatCompletions(String apiPerfixUrl, String apiKey, String bodyString, EventSourceListener listener) {
        HashMap<String, String> header = new HashMap<String, String>(1);
        if (StrUtil.isBlank((String)apiKey)) {
            throw new RuntimeException("api key can not empty");
        }
        header.put("Authorization", "Bearer " + apiKey);
        return OpenAiClient.chatCompletions(apiPerfixUrl, header, bodyString, listener);
    }

    public static Response chatCompletions(String uri, Map<String, String> requestHeaders, String bodyString) {
        OkHttpClient httpClient = OkHttpClientPool.get300HttpClient();
        RequestBody body = RequestBody.create((String)bodyString, (MediaType)MediaType.parse((String)"application/json"));
        Headers headers = Headers.of(requestHeaders);
        String url = uri + "/chat/completions";
        Request request = new Request.Builder().url(url).method("POST", body).headers(headers).build();
        try {
            return httpClient.newCall(request).execute();
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static Call chatCompletions(String serverUrl, String apiKey, OpenAiChatRequestVo chatRequestVo, Callback callback) {
        return OpenAiClient.chatCompletions(serverUrl, apiKey, Json.getSkipNullJson().toJson((Object)chatRequestVo), callback);
    }

    public static EventSource chatCompletions(String serverUrl, String apiKey, OpenAiChatRequestVo chatRequestVo, EventSourceListener listener) {
        return OpenAiClient.chatCompletions(serverUrl, apiKey, Json.getSkipNullJson().toJson((Object)chatRequestVo), listener);
    }

    public static Call chatCompletions(String apiPrefixUrl, Map<String, String> requestHeaders, String bodyString, Callback callback) {
        OkHttpClient httpClient = OkHttpClientPool.get300HttpClient();
        if (debug) {
            log.info(bodyString);
        }
        RequestBody body = RequestBody.create((String)bodyString, (MediaType)MediaType.parse((String)"application/json"));
        Headers headers = Headers.of(requestHeaders);
        String url = apiPrefixUrl + "/chat/completions";
        Request request = new Request.Builder().url(url).method("POST", body).headers(headers).build();
        Call newCall = httpClient.newCall(request);
        newCall.enqueue(callback);
        return newCall;
    }

    public static EventSource chatCompletions(String apiPrefixUrl, Map<String, String> requestHeaders, String bodyString, EventSourceListener listener) {
        OkHttpClient httpClient = OkHttpClientPool.get300HttpClient();
        if (debug) {
            log.info(bodyString);
        }
        RequestBody body = RequestBody.create((String)bodyString, (MediaType)MediaType.parse((String)"application/json"));
        Headers headers = Headers.of(requestHeaders);
        String url = apiPrefixUrl + "/chat/completions";
        Request request = new Request.Builder().url(url).method("POST", body).headers(headers).build();
        EventSource source = EventSources.createFactory((OkHttpClient)httpClient).newEventSource(request, listener);
        return source;
    }

    public static OpenAiChatResponseVo chat(String prompt) {
        OpenAiChatMessage chatMessage = new OpenAiChatMessage("user", prompt);
        return OpenAiClient.chatCompletions("gpt-4o-mini", chatMessage);
    }

    public static OpenAiChatResponseVo chatWithRole(String role, String prompt) {
        OpenAiChatMessage chatMessage = new OpenAiChatMessage(role, prompt);
        return OpenAiClient.chatCompletions("gpt-4o-mini", chatMessage);
    }

    public static OpenAiChatResponseVo chatWithModel(String model, String role, String prompt) {
        OpenAiChatMessage chatMessage = new OpenAiChatMessage(role, prompt);
        return OpenAiClient.chatCompletions(model, chatMessage);
    }

    public static OpenAiChatResponseVo chatWithModel(String apiUrl, String key, String model, String role, String prompt) {
        OpenAiChatMessage chatMessage = new OpenAiChatMessage(role, prompt);
        return OpenAiClient.chatCompletions(apiUrl, key, model, chatMessage);
    }

    public static OpenAiChatResponseVo chatCompletions(String apiUrl, String key, String model, OpenAiChatMessage chatMessage) {
        ArrayList<OpenAiChatMessage> messages = new ArrayList<OpenAiChatMessage>();
        messages.add(chatMessage);
        return OpenAiClient.chatCompletions(apiUrl, key, model, messages);
    }

    public static OpenAiChatResponseVo chatCompletions(String apiUrl, String key, String model, List<OpenAiChatMessage> messages) {
        OpenAiChatRequestVo chatRequestVo = new OpenAiChatRequestVo();
        chatRequestVo.setModel(model);
        chatRequestVo.setStream(false);
        chatRequestVo.setMessages(messages);
        return OpenAiClient.chatCompletions(apiUrl, key, chatRequestVo);
    }

    public static Response embeddings(String bodyString) {
        String apiKey = EnvUtils.get((String)"OPENAI_API_KEY");
        return OpenAiClient.embeddings(apiKey, bodyString);
    }

    public static Response embeddings(String apiKey, String bodyString) {
        String serverUrl = EnvUtils.get((String)"OPENAI_API_URL");
        return OpenAiClient.embeddings(serverUrl, apiKey, bodyString);
    }

    public static Response embeddings(String api_perfix_url, String apiKey, String bodyString) {
        if (api_perfix_url == null) {
            api_perfix_url = "https://api.openai.com/v1";
        }
        OkHttpClient httpClient = OkHttpClientPool.get300HttpClient();
        RequestBody body = RequestBody.create((String)bodyString, (MediaType)MediaType.parse((String)"application/json"));
        HashMap<String, String> requestHeaders = new HashMap<String, String>(1);
        if (StrUtil.isBlank((String)apiKey)) {
            throw new RuntimeException("api key can not empty");
        }
        requestHeaders.put("Authorization", "Bearer " + apiKey);
        Headers headers = Headers.of(requestHeaders);
        Request request = new Request.Builder().url(api_perfix_url + "/embeddings").method("POST", body).headers(headers).build();
        try {
            return httpClient.newCall(request).execute();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static float[] embeddingArray(String input, String model) {
        EmbeddingRequestVo embeddingRequestVo = new EmbeddingRequestVo(model, input);
        String apiKey = EnvUtils.get((String)"OPENAI_API_KEY");
        return OpenAiClient.embeddings(apiKey, embeddingRequestVo).getData().get(0).getEmbedding();
    }

    public static float[] embeddingArray(String apiKey, String input, String model) {
        EmbeddingRequestVo embeddingRequestVo = new EmbeddingRequestVo(input, model);
        return OpenAiClient.embeddings(apiKey, embeddingRequestVo).getData().get(0).getEmbedding();
    }

    public static float[] embeddingArray(String input) {
        return OpenAiClient.embeddingArray(input, "text-embedding-3-small");
    }

    public static float[] embeddingArrayByLargeModel(String input) {
        return OpenAiClient.embeddingArray(input, "text-embedding-3-large");
    }

    public static EmbeddingResponseVo embeddings(EmbeddingRequestVo embeddingRequestVo) {
        String apiKey = EnvUtils.get((String)"OPENAI_API_KEY");
        return OpenAiClient.embeddings(apiKey, embeddingRequestVo);
    }

    public static EmbeddingResponseVo embeddings(String serverUrl, String apiKey, EmbeddingRequestVo reoVo) {
        EmbeddingResponseVo respVo;
        block15: {
            respVo = null;
            try (Response response = OpenAiClient.embeddings(serverUrl, apiKey, Json.getSkipNullJson().toJson((Object)reoVo));){
                String bodyString = response.body().string();
                if (response.isSuccessful()) {
                    respVo = (EmbeddingResponseVo)JsonUtils.parse((String)bodyString, EmbeddingResponseVo.class);
                    break block15;
                }
                throw new RuntimeException("status:" + response.code() + ",sbody:" + bodyString);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return respVo;
    }

    public static EmbeddingResponseVo embeddings(String apiKey, EmbeddingRequestVo reoVo) {
        EmbeddingResponseVo respVo;
        block15: {
            respVo = null;
            String json = Json.getSkipNullJson().toJson((Object)reoVo);
            try (Response response = OpenAiClient.embeddings(apiKey, json);){
                String bodyString = response.body().string();
                if (response.isSuccessful()) {
                    respVo = (EmbeddingResponseVo)JsonUtils.parse((String)bodyString, EmbeddingResponseVo.class);
                    break block15;
                }
                String serverUrl = EnvUtils.get((String)"OPENAI_API_URL");
                throw new GenerateException("openai", "Failed to Embedding", serverUrl, json, response.code(), bodyString);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return respVo;
    }

    public static float[] embeddingArray(String serverUrl, String apiKey, String input, String model) {
        EmbeddingRequestVo reqVo = new EmbeddingRequestVo(input, model);
        return OpenAiClient.embeddingArray(serverUrl, apiKey, reqVo);
    }

    public static float[] embeddingArray(String serverUrl, String apiKey, EmbeddingRequestVo reqVo) {
        EmbeddingResponseVo embeddings = OpenAiClient.embeddings(serverUrl, apiKey, reqVo);
        return embeddings.getData().get(0).getEmbedding();
    }

    public static OpenAiChatResponseVo chatWithImage(String prompt, byte[] bytes, String suffix) {
        String apiKey = EnvUtils.get((String)"OPENAI_API_KEY");
        return OpenAiClient.chatWithImage(apiKey, prompt, bytes, suffix);
    }

    public static OpenAiChatResponseVo chatWithImage(String apiKey, String model, String prompt, byte[] bytes, String suffix) {
        ChatMessageContent text = new ChatMessageContent(prompt);
        ChatMessageContent image = new ChatMessageContent(bytes, suffix);
        ArrayList<ChatMessageContent> multiContents = new ArrayList<ChatMessageContent>();
        multiContents.add(text);
        multiContents.add(image);
        OpenAiChatMessage user = new OpenAiChatMessage();
        user.role("user").multiContents(multiContents);
        ArrayList<OpenAiChatMessage> messages = new ArrayList<OpenAiChatMessage>();
        messages.add(user);
        OpenAiChatRequestVo openAiChatRequestVo = new OpenAiChatRequestVo();
        openAiChatRequestVo.setModel(model);
        openAiChatRequestVo.setMessages(messages);
        return OpenAiClient.chatCompletions(apiKey, openAiChatRequestVo);
    }

    public static OpenAiChatResponseVo chatWithImage(String apiKey, String prompt, byte[] bytes, String suffix) {
        return OpenAiClient.chatWithImage(apiKey, "gpt-4o-mini", prompt, bytes, suffix);
    }
}

