/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.utils.ibot.robot;

import com.alibaba.fastjson.JSON;
import com.litongjava.utils.http.litonghttpclient.HttpClientUtils;
import com.litongjava.utils.ibot.robot.AskRequest;
import com.litongjava.utils.ibot.robot.AskResponse;
import com.litongjava.utils.ibot.robot.CommandsBean;
import com.litongjava.utils.ibot.robot.NLPResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NLPHttpclient {
    private static final Logger log = LoggerFactory.getLogger(NLPHttpclient.class);

    public static AskResponse ask(String nlpURL, AskRequest aq, String askEx) {
        AskResponse retval = new AskResponse();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userId", aq.getUserId());
        params.put("question", aq.getQuestion());
        params.put("sessionId", aq.getSessionId());
        params.put("format", aq.getFormat());
        params.put("platform", aq.getPlatform());
        params.put("user_ask_ex", askEx);
        log.info(nlpURL + "," + params);
        String httpResponse = HttpClientUtils.post(nlpURL, null, params);
        String format = aq.getFormat();
        if (format != null && format.equalsIgnoreCase("json")) {
            NLPResponse nr = (NLPResponse)JSON.parseObject((String)httpResponse, NLPResponse.class);
            if (nr.getType() == 0) {
                nr = NLPHttpclient.getDefaultReply();
            }
            retval.setType(nr.getType());
            String content = nr.getContent();
            if (content.startsWith("\r\n")) {
                content = content.substring(2, nr.getContent().length());
                retval.setContent(content);
            }
            retval.setContent(content);
            retval.setSimilarity(nr.getSimilarity());
            retval.setRelatedQuestions(nr.getRelatedQuestions());
            retval.setModuleId(nr.getModuleId());
            List<CommandsBean> cs = nr.getCommands();
            AskResponse.PropsBean p = new AskResponse.PropsBean();
            for (CommandsBean c : cs) {
                if (c.getName().equals("prop.categoryId")) {
                    p.setCategoryId(c.getArgs().get(0));
                    continue;
                }
                if (c.getName().equals("prop.objectId")) {
                    p.setObjectId(c.getArgs().get(0));
                    continue;
                }
                if (!c.getName().equals("prop.sessionId")) continue;
                p.setSessionId(c.getArgs().get(0));
            }
            retval.setProps(p);
            retval.setCommands(cs);
        }
        return retval;
    }

    private static NLPResponse getDefaultReply() {
        NLPResponse nlpResponse = new NLPResponse();
        nlpResponse.setType(0);
        nlpResponse.setContent("defaultReply");
        nlpResponse.setCommands(new ArrayList<CommandsBean>());
        return nlpResponse;
    }
}

