/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.utils.ip;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;

public class IPUtils {
    public static InetAddress getLocalHostLANAddress() {
        Enumeration<NetworkInterface> networkInterfaces = null;
        try {
            networkInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e1) {
            e1.printStackTrace();
        }
        InetAddress candidateAddress = null;
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface networkInterface = networkInterfaces.nextElement();
            Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
            while (inetAddresses.hasMoreElements()) {
                InetAddress inetAddress = inetAddresses.nextElement();
                if (IPUtils.isLocalIf(inetAddress)) {
                    return inetAddress;
                }
                candidateAddress = inetAddress;
            }
        }
        if (candidateAddress != null) {
            return candidateAddress;
        }
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            return localHost;
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static boolean isLocalIf(InetAddress inetAddress) {
        return inetAddress.isSiteLocalAddress() && !inetAddress.getHostAddress().equals("172.17.0.1");
    }

    private static String toHexString(int i) {
        String str = Integer.toHexString(i & 0xFF);
        if (str.length() == 1) {
            str = "0" + str;
        }
        return str;
    }

    public static String getMac(InetAddress inetAddress) {
        NetworkInterface byInetAddress = null;
        try {
            byInetAddress = NetworkInterface.getByInetAddress(inetAddress.getLocalHost());
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        byte[] hardwareAddress = null;
        try {
            hardwareAddress = byInetAddress.getHardwareAddress();
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < hardwareAddress.length; ++i) {
            String hexString = IPUtils.toHexString(hardwareAddress[i]);
            if (i < hardwareAddress.length - 1) {
                stringBuffer.append(hexString + "-");
                continue;
            }
            stringBuffer.append(hexString);
        }
        return stringBuffer.toString();
    }

    public static String getThisUrl(int port, String contextPath) {
        String ip = IPUtils.getLocalHostLANAddress().getHostAddress();
        String retval = "http://" + ip + ":" + port + contextPath;
        return retval;
    }
}

