/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.utils.ip;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class IpUtils {
    public static List<InetAddress> getLocalHostLANAddress() {
        ArrayList<InetAddress> retval = new ArrayList<InetAddress>();
        Enumeration<NetworkInterface> networkInterfaces = null;
        try {
            networkInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e1) {
            e1.printStackTrace();
        }
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface networkInterface = networkInterfaces.nextElement();
            Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
            while (inetAddresses.hasMoreElements()) {
                InetAddress inetAddress = inetAddresses.nextElement();
                if (!IpUtils.isRealIp(inetAddress)) continue;
                retval.add(inetAddress);
            }
        }
        if (retval.size() < 1) {
            try {
                InetAddress localHost = InetAddress.getLocalHost();
                retval.add(localHost);
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
        }
        return retval;
    }

    private static boolean isRealIp(InetAddress inetAddress) {
        return inetAddress.isSiteLocalAddress() && !inetAddress.getHostAddress().equals("172.17.0.1");
    }

    private static String toHexString(int i) {
        String str = Integer.toHexString(i & 0xFF);
        if (str.length() == 1) {
            str = "0" + str;
        }
        return str;
    }

    public static String getMac(InetAddress inetAddress) {
        NetworkInterface byInetAddress = null;
        try {
            byInetAddress = NetworkInterface.getByInetAddress(inetAddress.getLocalHost());
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        byte[] hardwareAddress = null;
        try {
            hardwareAddress = byInetAddress.getHardwareAddress();
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < hardwareAddress.length; ++i) {
            String hexString = IpUtils.toHexString(hardwareAddress[i]);
            if (i < hardwareAddress.length - 1) {
                stringBuffer.append(hexString + "-");
                continue;
            }
            stringBuffer.append(hexString);
        }
        return stringBuffer.toString();
    }

    public static String[] getThisUrl(int port, String contextPath) {
        List<InetAddress> localHostLANAddress = IpUtils.getLocalHostLANAddress();
        String[] retval = new String[localHostLANAddress.size()];
        for (int i = 0; i < localHostLANAddress.size(); ++i) {
            String message;
            InetAddress inetAddress = localHostLANAddress.get(i);
            retval[i] = message = "http://" + inetAddress.getHostAddress() + ":" + port + contextPath;
            System.out.println(message);
        }
        return retval;
    }
}

