/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.utils.image;

import com.litongjava.utils.image.Graphics2DUtils;
import com.litongjava.utils.image.ImageText;
import com.litongjava.utils.image.ImageUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;

public class ImageLogoUtils {
    public static BufferedImage getTransparencyImage(int width, int height) {
        ColorModel cm = ColorModel.getRGBdefault();
        WritableRaster wr = cm.createCompatibleWritableRaster(width, height);
        BufferedImage bufferedImage = new BufferedImage(cm, wr, cm.isAlphaPremultiplied(), null);
        return bufferedImage;
    }

    public static BufferedImage drawLogo(int w, int h, int fontSize, int paddingSize, String s1, String s2, String s3, String s4) {
        BufferedImage logo = ImageLogoUtils.getTransparencyImage(w, h);
        Graphics2D g2d = logo.createGraphics();
        Color color = new Color(255, 255, 255);
        Font font = new Font("\u5fae\u8f6f\u96c5\u9ed1", 1, fontSize);
        ImageText pinImageText = ImageUtils.createImageText(s1, color, font, paddingSize, paddingSize);
        Graphics2DUtils.drawString(g2d, pinImageText);
        ImageText tuImageText = ImageUtils.createImageText(s2, color, font, w / 2 + paddingSize, paddingSize);
        Graphics2DUtils.drawString(g2d, tuImageText);
        ImageText gongImageText = ImageUtils.createImageText(s3, color, font, paddingSize, h / 2 + paddingSize);
        Graphics2DUtils.drawString(g2d, gongImageText);
        ImageText juImageText = ImageUtils.createImageText(s4, color, font, h / 2 + paddingSize, w / 2 + paddingSize);
        Graphics2DUtils.drawString(g2d, juImageText);
        g2d.dispose();
        return logo;
    }
}

