/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.utils.process;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessUtils {
    private static final Logger log = LoggerFactory.getLogger(ProcessUtils.class);

    public static Process start(List<String> commands) throws IOException {
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.command(commands);
        return builder.start();
    }

    public static String start(String command) {
        Process process = null;
        System.out.println("start run cmd:" + command);
        try {
            process = Runtime.getRuntime().exec(command);
        }
        catch (IOException e) {
            e.printStackTrace();
            log.info("run cmd exception:{}", (Object)command);
            return null;
        }
        String retval = ProcessUtils.printRunInfo(process);
        process.destroy();
        return retval;
    }

    private static String printRunInfo(final Process process) {
        final StringBuffer retval = new StringBuffer();
        new Thread(){

            @Override
            public void run() {
                String line = null;
                try (BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                    while ((line = in.readLine()) != null) {
                        retval.append("output:" + line + "\r\n");
                        System.out.println("output:" + line);
                    }
                }
                catch (IOException e) {
                    log.error("\u8bfb\u53d6\u6d41\u73b0\u5f02\u5e38:{}", (Object)e.getMessage());
                }
            }
        }.start();
        new Thread(){

            @Override
            public void run() {
                String line = null;
                try (BufferedReader err = new BufferedReader(new InputStreamReader(process.getErrorStream()));){
                    while ((line = err.readLine()) != null) {
                        retval.append("err:" + line + "\r\n");
                        System.err.println("err:" + line);
                    }
                }
                catch (IOException e) {
                    log.error("\u8bfb\u53d6\u6d41\u73b0\u5f02\u5e38:{}", (Object)e.getMessage());
                }
            }
        }.start();
        try {
            process.waitFor();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return retval.toString();
    }
}

