/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.utils.httpclient;

import com.litongjava.utils.httpclient.HttpResponse;
import com.litongjava.utils.io.IOUtils;
import com.litongjava.utils.io.StreamUtils;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpURLConnectionUtils {
    private static final Logger log = LoggerFactory.getLogger(HttpURLConnectionUtils.class);

    private static URL initHttpURL(String targetUrl) {
        URL url = null;
        try {
            url = new URL(targetUrl);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return url;
    }

    public static URL initHttpURL(String url, Map<String, Object> param) {
        StringBuffer params = null;
        if (param != null && (params = HttpURLConnectionUtils.buildHttpQueryParams(param)).length() > 0) {
            url = url + "?" + params.toString();
        }
        return HttpURLConnectionUtils.initHttpURL(url);
    }

    public static HttpURLConnection getConnection(String targetUrl, String method, Map<String, String> headers) {
        URL initHttpURL = HttpURLConnectionUtils.initHttpURL(targetUrl);
        return HttpURLConnectionUtils.getConnection(initHttpURL, method, headers);
    }

    public static HttpURLConnection getConnection(URL httpURL, String method, Map<String, String> headers) {
        HttpURLConnection httpConnection = null;
        try {
            httpConnection = (HttpURLConnection)httpURL.openConnection();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        if (method != null) {
            try {
                httpConnection.setRequestMethod(method);
            }
            catch (ProtocolException e1) {
                e1.printStackTrace();
            }
        }
        if (headers != null) {
            for (Map.Entry<String, String> e : headers.entrySet()) {
                httpConnection.setRequestProperty(e.getKey(), e.getValue());
            }
        }
        return httpConnection;
    }

    public static String get(String url, Map<String, Object> param) {
        return HttpURLConnectionUtils.get(url, null, param).getResponse();
    }

    public static HttpResponse get(String targetUrl, Map<String, String> header, Map<String, Object> body) {
        HttpResponse ret = new HttpResponse();
        URL httpURL = HttpURLConnectionUtils.initHttpURL(targetUrl, body);
        StringBuffer sb = new StringBuffer();
        try {
            HttpURLConnection httpConnection = (HttpURLConnection)httpURL.openConnection();
            httpConnection.setRequestMethod("GET");
            HttpURLConnectionUtils.setHeaders(httpConnection, header);
            int statusCode = httpConnection.getResponseCode();
            ret.setCode(statusCode);
            ret.setHeader(httpConnection.getHeaderFields());
            if (statusCode != 200) {
                if (statusCode == 404) {
                    throw new RuntimeException(statusCode + ":" + httpURL.toString());
                }
                throw new RuntimeException("HTTP GET Request Failed with Error code : " + httpConnection.getResponseCode());
            }
            sb = IOUtils.toStringBuffer(httpConnection.getInputStream());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ret.setResponse(sb.toString());
        return ret;
    }

    public static void setHeaders(HttpURLConnection httpConnection, Map<String, String> header) {
        if (header == null) {
            return;
        }
        for (Map.Entry<String, String> e : header.entrySet()) {
            httpConnection.setRequestProperty(e.getKey(), e.getValue());
        }
    }

    public static String post(String url, Map<String, Object> param) {
        return HttpURLConnectionUtils.post(url, null, param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String post(String targetUrl, Map<String, String> headers, Map<String, Object> params) {
        StringBuffer sb;
        block8: {
            StringBuffer requestString = HttpURLConnectionUtils.buildHttpQueryParams(params);
            sb = null;
            URL httpURL = HttpURLConnectionUtils.initHttpURL(targetUrl);
            HttpURLConnection httpConn = null;
            try {
                httpConn = (HttpURLConnection)httpURL.openConnection();
                if (headers != null) {
                    for (Map.Entry<String, String> e : headers.entrySet()) {
                        httpConn.setRequestProperty(e.getKey(), e.getValue());
                    }
                }
                httpConn.setRequestMethod("POST");
                HttpURLConnectionUtils.setPostConnection(httpConn);
                httpConn.connect();
                DataOutputStream dos = new DataOutputStream(httpConn.getOutputStream());
                dos.writeBytes(requestString.toString());
                dos.flush();
                dos.close();
                if (httpConn.getResponseCode() == 200) {
                    sb = IOUtils.toStringBuffer(httpConn.getInputStream());
                    break block8;
                }
                throw new RuntimeException("HTTP POST Request Failed with Error code : " + httpConn.getResponseCode() + "," + targetUrl);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                httpConn.disconnect();
            }
        }
        return sb.toString();
    }

    public static StringBuffer buildHttpQueryParams(Map<String, Object> param) {
        StringBuffer sb = new StringBuffer();
        for (Map.Entry<String, Object> e : param.entrySet()) {
            sb.append(e.getKey() + "=" + URLEncoder.encode(e.getValue().toString()) + "&");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.lastIndexOf("&"));
        }
        return sb;
    }

    public static HttpURLConnection execute(String targetUrl, String method, Map<String, String> headers, Map<String, Object> body) throws MalformedURLException {
        log.info("{}:{}", (Object)method, (Object)targetUrl);
        if ("GET".equals(method)) {
            return HttpURLConnectionUtils.executeGet(targetUrl, method, headers, body);
        }
        return HttpURLConnectionUtils.executePost(targetUrl, method, headers, body);
    }

    public static HttpURLConnection executeGet(String targetUrl, String method, Map<String, String> headers, Map<String, Object> reqParam) {
        URL httpURL = HttpURLConnectionUtils.initHttpURL(targetUrl, reqParam);
        return HttpURLConnectionUtils.getConnection(httpURL, method, headers);
    }

    private static HttpURLConnection executePost(String targetUrl, String method, Map<String, String> param, Map<String, Object> headers) {
        return null;
    }

    public static HttpURLConnection executeValues(String targetUrl, String method, Map<String, String> headers, Map<String, String[]> reqMap) {
        return null;
    }

    public static HttpURLConnection execute(String targetUrl, String method, Map<String, String> headers, InputStream reqInputStream) {
        HttpURLConnection connection = HttpURLConnectionUtils.getConnection(targetUrl, method, headers);
        if ("POST".equals(method)) {
            HttpURLConnectionUtils.setPostConnection(connection);
            HttpURLConnectionUtils.postStream(connection, reqInputStream);
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void postStream(HttpURLConnection connection, InputStream reqInputStream) {
        DataOutputStream dos = null;
        try {
            dos = new DataOutputStream(connection.getOutputStream());
            StreamUtils.copy(reqInputStream, (OutputStream)dos);
            dos.flush();
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(dos);
                throw throwable;
            }
            IOUtils.closeQuietly(dos);
        }
        IOUtils.closeQuietly(dos);
    }

    private static void setPostConnection(HttpURLConnection connection) {
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setUseCaches(false);
        connection.setInstanceFollowRedirects(true);
    }

    public static void disconnect(HttpURLConnection httpURLConnection) {
        if (httpURLConnection != null) {
            httpURLConnection.disconnect();
        }
    }
}

