/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.utils.image;

import com.litongjava.utils.image.ImageText;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageUtils {
    private static final Logger log = LoggerFactory.getLogger(ImageUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] reduce(byte[] bytes) {
        MemoryCacheImageInputStream inputStream = new MemoryCacheImageInputStream(new ByteArrayInputStream(bytes));
        BufferedImage srcImage = null;
        String formatName = null;
        try {
            srcImage = ImageIO.read(inputStream);
            formatName = ImageUtils.getImageFormatByBytes(bytes);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly((Closeable)inputStream);
        }
        AffineTransformOp ato = ImageUtils.getAffineTransformOp(0.5);
        BufferedImage destImage = ato.filter(srcImage, null);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] retval = null;
        try {
            ImageIO.write((RenderedImage)destImage, formatName, (OutputStream)outputStream);
            retval = outputStream.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly((OutputStream)outputStream);
        }
        return retval;
    }

    public static String getImageFormatByBytes(byte[] content) {
        String string;
        MemoryCacheImageInputStream input = null;
        try {
            input = new MemoryCacheImageInputStream(new ByteArrayInputStream(content));
            string = ImageUtils.getImageFormat(input);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(input);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)input);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getImageFormat(ImageInputStream input) {
        Iterator<ImageReader> readers = ImageIO.getImageReaders(input);
        String format = "unknown";
        if (readers.hasNext()) {
            ImageReader reader = readers.next();
            try {
                format = reader.getFormatName();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                reader.dispose();
            }
        }
        return format;
    }

    private static AffineTransformOp getAffineTransformOp(double d) {
        AffineTransform scaleInstance = AffineTransform.getScaleInstance(d, d);
        return new AffineTransformOp(scaleInstance, null);
    }

    public static BufferedImage load(String imgName) {
        try {
            return ImageIO.read(new File(imgName));
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
            return null;
        }
    }

    public static BufferedImage merge(BufferedImage image1, BufferedImage image2) {
        int w = image1.getWidth() + image2.getWidth();
        int h = image1.getHeight();
        BufferedImage retval = new BufferedImage(w, h, 5);
        int image1Width = image1.getWidth();
        Graphics2D g = retval.createGraphics();
        g.drawImage(image1, 0, 0, image1.getWidth(), h, null);
        g.drawImage(image2, image1Width, 0, image2.getWidth(), h, null);
        g.dispose();
        return retval;
    }

    public static void write(String targetImgPath, BufferedImage img) {
        ImageUtils.write(targetImgPath, "jpg", img);
    }

    public static void write(String targetImgPath, String format, BufferedImage img) {
        if (targetImgPath != null && img != null) {
            try {
                File outputfile = new File(targetImgPath);
                ImageIO.write((RenderedImage)img, format, outputfile);
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
            }
        }
    }

    public static void writeImage(BufferedImage bufImg, String tarImgPath, ArrayList<ImageText> list) {
        Graphics2D g = bufImg.createGraphics();
        for (ImageText imageText : list) {
            g.setColor(imageText.getColor());
            g.setFont(imageText.getFont());
            g.drawString(imageText.getText(), imageText.getX(), imageText.getY());
        }
        g.dispose();
        ImageUtils.write(tarImgPath, bufImg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeImage(String srcImgPath, String targetImgPath, List<ImageText> list) {
        OutputStream outImgStream = null;
        File srcImgFile = new File(srcImgPath);
        try {
            BufferedImage srcImg = ImageIO.read(srcImgFile);
            int srcImgWidth = ((Image)srcImg).getWidth(null);
            int srcImgHeight = ((Image)srcImg).getHeight(null);
            BufferedImage bufImg = new BufferedImage(srcImgWidth, srcImgHeight, 1);
            Graphics2D g = bufImg.createGraphics();
            g.drawImage(srcImg, 0, 0, srcImgWidth, srcImgHeight, null);
            for (ImageText imageText : list) {
                g.setColor(imageText.getColor());
                g.setFont(imageText.getFont());
                g.drawString(imageText.getText(), imageText.getX(), imageText.getY());
            }
            g.dispose();
            outImgStream = new FileOutputStream(targetImgPath);
            ImageIO.write((RenderedImage)bufImg, "jpg", outImgStream);
        }
        catch (Exception e) {
            log.error("==== \u7cfb\u7edf\u5f02\u5e38::{} ====", (Throwable)e);
        }
        finally {
            try {
                if (null != outImgStream) {
                    outImgStream.flush();
                    ((FileOutputStream)outImgStream).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static ImageText createImageText(String text, Color color, Font font, int x, int y) {
        ImageText imageText = new ImageText();
        imageText.setText(text);
        imageText.setColor(color);
        imageText.setFont(font);
        imageText.setX(x);
        imageText.setY(y);
        return imageText;
    }

    public static BufferedImage merge(String srcImagePath1, String srcImagePath2) {
        BufferedImage image1 = ImageUtils.load(srcImagePath1);
        BufferedImage image2 = ImageUtils.load(srcImagePath2);
        return ImageUtils.merge(image1, image2);
    }
}

