/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.utils.maven;

import com.litongjava.utils.maven.Dependency;
import com.litongjava.utils.xml.dom.DOMUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MavenInstall {
    private static final Logger log = LoggerFactory.getLogger(MavenInstall.class);
    public static List<String> notSupportedJar = new ArrayList<String>();

    public static String install(String mvnPath, String jarPath, String localMavenPath) {
        String retval = "<dependencies>";
        File jarPathFile = new File(jarPath);
        File[] listFiles = jarPathFile.listFiles();
        for (File file : listFiles) {
            String dependency;
            if (!file.getName().endsWith(".jar") || (dependency = MavenInstall.install(mvnPath, file, localMavenPath)) == null) continue;
            retval = retval + dependency;
        }
        retval = retval + "</dependencies>";
        System.out.println("\u9700\u8981\u624b\u5de5\u5904\u7406\u7684jar");
        for (String s : notSupportedJar) {
            System.out.println(s);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static String install(String mvnPath, File file, String localMavenPath) {
        Dependency dependency = null;
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(file);
            dependency = MavenInstall.getDependency(zipFile);
        }
        catch (ZipException e) {
            e.printStackTrace();
            MavenInstall.close(zipFile);
        }
        catch (IOException e2) {
            e2.printStackTrace();
            {
                catch (Throwable throwable) {
                    MavenInstall.close(zipFile);
                    throw throwable;
                }
            }
            MavenInstall.close(zipFile);
        }
        MavenInstall.close(zipFile);
        if (dependency != null) {
            String cmd = MavenInstall.executeInstallCommand(mvnPath, dependency, localMavenPath);
            System.out.println(cmd);
            String retval = MavenInstall.dependencyToXML(dependency);
            return retval;
        }
        return null;
    }

    private static String executeInstallCommand(String mvmpath, Dependency dependency, String localRepositoryPath) {
        StringBuffer strBuf = new StringBuffer();
        strBuf.append(mvmpath + " install:install-file");
        strBuf.append(" -DgroupId=" + dependency.getGroupId());
        strBuf.append(" -DartifactId=" + dependency.getArtifactId());
        strBuf.append(" -Dversion=" + dependency.getVersion());
        strBuf.append(" -Dfile=" + dependency.getJarPath());
        strBuf.append(" -DpomFile=" + dependency.getPomPath());
        strBuf.append(" -DlocalRepositoryPath=" + localRepositoryPath);
        strBuf.append(" -DcreateChecksum=true");
        strBuf.append(" -Dpackaging=jar");
        String retval = strBuf.toString();
        return retval;
    }

    private static Dependency getDependency(ZipFile zipFile) {
        String version;
        String jarPath = zipFile.getName();
        log.info("\u5904\u7406jar:" + jarPath);
        Dependency dependency = new Dependency();
        dependency.setJarPath(zipFile.getName());
        String pomPath = jarPath + ".pom";
        String[] array = MavenInstall.getPom(zipFile, pomPath);
        if (array[0].equals("0")) {
            Node item;
            int i;
            Document document = DOMUtils.stringToDom(array[2]);
            Element rootEle = document.getDocumentElement();
            NodeList nodeList = rootEle.getElementsByTagName("groupId");
            String groupId = null;
            for (i = 0; i < nodeList.getLength(); ++i) {
                item = nodeList.item(i);
                if (!item.getParentNode().getNodeName().equals("project")) continue;
                groupId = item.getTextContent();
                break;
            }
            if (groupId == null) {
                groupId = nodeList.item(0).getTextContent();
            }
            dependency.setGroupId(groupId);
            nodeList = rootEle.getElementsByTagName("artifactId");
            for (i = 0; i < nodeList.getLength(); ++i) {
                item = nodeList.item(i);
                if (!item.getParentNode().getNodeName().equals("project")) continue;
                String artifactId = item.getTextContent();
                dependency.setArtifactId(artifactId);
                break;
            }
            nodeList = rootEle.getElementsByTagName("version");
            version = null;
            for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
                Node item2 = nodeList.item(i2);
                if (!item2.getParentNode().getNodeName().equals("project")) continue;
                version = item2.getTextContent();
                break;
            }
            if (version == null) {
                version = nodeList.item(0).getTextContent();
            }
        } else {
            notSupportedJar.add(jarPath);
            return null;
        }
        dependency.setVersion(version);
        dependency.setPomPath(pomPath);
        return dependency;
    }

    private static String[] getPom(ZipFile zipFile, String pomPath) {
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry zipEntry = entries.nextElement();
            if (!zipEntry.getName().endsWith("pom.xml")) continue;
            String text = MavenInstall.getWriteFile(zipFile, zipEntry, pomPath);
            String[] retval = new String[]{"0", pomPath, text};
            return retval;
        }
        String[] retval = new String[]{"1", pomPath, ""};
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getWriteFile(ZipFile zipFile, ZipEntry zipEntry, String pomPath) {
        InputStream inputStream = null;
        String text = null;
        try {
            inputStream = zipFile.getInputStream(zipEntry);
            text = MavenInstall.getText(inputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        try {
            FileUtils.writeStringToFile((File)new File(pomPath), (String)text);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getText(InputStream inputStream) {
        BufferedReader bufReader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuffer stringBuffer = new StringBuffer();
        String line = null;
        try {
            while ((line = bufReader.readLine()) != null) {
                stringBuffer.append(line);
                stringBuffer.append(System.getProperty("line.separator"));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly((Reader)bufReader);
        }
        return stringBuffer.toString();
    }

    private static void close(ZipFile zipFile) {
        if (zipFile != null) {
            try {
                zipFile.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static String dependencyToXML(Dependency dependency) {
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("<dependency>");
        strBuf.append("<groupId>" + dependency.getGroupId() + "</groupId>");
        strBuf.append("<artifactId>" + dependency.getArtifactId() + "</artifactId>");
        strBuf.append("<version>" + dependency.getVersion() + "</version>");
        strBuf.append("</dependency>");
        return strBuf.toString();
    }
}

