/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.utils.audio;

import java.io.File;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import org.jaudiotagger.audio.AudioFileIO;
import org.jaudiotagger.audio.mp3.MP3AudioHeader;
import org.jaudiotagger.audio.mp3.MP3File;

public class AudioUtils {
    public static Float getDuration(String filePath) {
        File destFile = new File(filePath);
        try {
            AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(destFile);
            AudioFormat format = audioInputStream.getFormat();
            long audioFileLength = destFile.length();
            int frameSize = format.getFrameSize();
            float frameRate = format.getFrameRate();
            float durationInSeconds = (float)audioFileLength / ((float)frameSize * frameRate);
            return Float.valueOf(durationInSeconds);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Float.valueOf(0.0f);
        }
    }

    public static Float getMp3Duration(String filePath) {
        try {
            File mp3File = new File(filePath);
            MP3File f = (MP3File)AudioFileIO.read((File)mp3File);
            MP3AudioHeader audioHeader = (MP3AudioHeader)f.getAudioHeader();
            return Float.valueOf(Float.parseFloat(audioHeader.getTrackLength() + ""));
        }
        catch (Exception e) {
            e.printStackTrace();
            return Float.valueOf(0.0f);
        }
    }

    public static Float getMp3Duration(File mp3File) {
        try {
            MP3File f = (MP3File)AudioFileIO.read((File)mp3File);
            MP3AudioHeader audioHeader = (MP3AudioHeader)f.getAudioHeader();
            return Float.valueOf(Float.parseFloat(audioHeader.getTrackLength() + ""));
        }
        catch (Exception e) {
            e.printStackTrace();
            return Float.valueOf(0.0f);
        }
    }

    public static long getPCMDurationMilliSecond(String filePath) {
        File file = new File(filePath);
        long second = file.length() / 32000L;
        long milliSecond = Math.round((double)(file.length() % 32000L) / 32000.0 * 1000.0);
        return second * 1000L + milliSecond;
    }
}

