/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.utils.bigdecimal;

import java.math.BigDecimal;
import java.text.NumberFormat;

public class BigDecimalUnitUtils {
    public static BigDecimal to10K(BigDecimal input) {
        return input.divide(BigDecimal.valueOf(10000.0), 2, 4);
    }

    public static BigDecimal to100M(BigDecimal input) {
        return input.divide(BigDecimal.valueOf(1.0E8), 2, 4);
    }

    public static BigDecimal to10K(Long input) {
        return BigDecimalUnitUtils.to10K(BigDecimal.valueOf(input));
    }

    public static String toPercent(Long part, BigDecimal total, int scale) {
        return BigDecimalUnitUtils.toPercent(BigDecimal.valueOf(part), total, scale);
    }

    public static String toPercent(BigDecimal part, BigDecimal total, int scale) {
        BigDecimal divide = part.divide(total, 4, 5);
        NumberFormat percentFormat = NumberFormat.getPercentInstance();
        percentFormat.setMaximumFractionDigits(scale);
        String perent = percentFormat.format(divide.doubleValue());
        return perent;
    }

    public static String toPercent(Long part, Long total, int scale) {
        return BigDecimalUnitUtils.toPercent(BigDecimal.valueOf(part), BigDecimal.valueOf(total), scale);
    }
}

