/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.utils.date;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class DateUtils {
    private static SimpleDateFormat sdfDate = null;
    Map<String, SimpleDateFormat> sdfMaps = new HashMap<String, SimpleDateFormat>();
    private static final String HYPHEN = "-";

    public static String getyyyy_MM_ddString(Date date) {
        String str = sdfDate.format(date);
        return str;
    }

    public static Date getyyyy_MM_dd(Date date) {
        String str = DateUtils.getyyyy_MM_ddString(date);
        Date d = null;
        try {
            d = sdfDate.parse(str);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return d;
    }

    public static Date getDayAgo(int i) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(6, i);
        Date time = calendar.getTime();
        return time;
    }

    public Date toDate(String str, String format) throws ParseException {
        SimpleDateFormat sdf = this.getSimpleDateFormat(format);
        Date parse = sdf.parse(str);
        return parse;
    }

    public String toString(Date date, String format) {
        SimpleDateFormat sdf = this.getSimpleDateFormat(format);
        String string = sdf.format(date);
        return string;
    }

    private SimpleDateFormat getSimpleDateFormat(String format) {
        SimpleDateFormat sdf = this.sdfMaps.get(format);
        if (sdf == null) {
            sdf = new SimpleDateFormat(format);
            this.sdfMaps.put(format, sdf);
        }
        return sdf;
    }

    public static boolean isBetween(Date d1, Date d2, Date d3) {
        Calendar instance = Calendar.getInstance();
        instance.setTime(d1);
        long l1 = instance.getTimeInMillis();
        instance.setTime(d2);
        long l2 = instance.getTimeInMillis();
        instance.setTime(d3);
        long l3 = instance.getTimeInMillis();
        return l3 > l1 && l3 < l2;
    }

    public static Date getDate(Date date) {
        return null;
    }

    public static Date getFirstDayOfMonth() {
        Calendar cal = Calendar.getInstance();
        int firstDay = cal.getMinimum(5);
        cal.set(5, firstDay);
        return cal.getTime();
    }

    public static Date getFirstDayOfMonth(int year, int month) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        int firstDay = cal.getMinimum(5);
        cal.set(5, firstDay);
        return cal.getTime();
    }

    public static Date getFirstDayOfYear(Date year) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(year);
        calendar.set(calendar.get(1), 0, 1);
        return calendar.getTime();
    }

    public static BigDecimal getDefaultInvalidTime() {
        String defaultInvalidTime = "9999-12-31";
        return DateUtils.strToBigDecimal(defaultInvalidTime);
    }

    public static BigDecimal getNowDate() {
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String createdate = sdf.format(date);
        return DateUtils.strToBigDecimal(createdate);
    }

    public static BigDecimal strToBigDecimal(String effectiveDate) {
        String[] splitWithHyphen;
        StringBuilder sb = new StringBuilder();
        for (String item : splitWithHyphen = effectiveDate.split(HYPHEN)) {
            sb.append(item);
        }
        String newEffectiveDate = sb.toString();
        BigDecimal bd = new BigDecimal(newEffectiveDate);
        return bd;
    }

    public static String bigDecimalToStr(BigDecimal effectiveDate) {
        String strEffectiveDate = effectiveDate.toString();
        StringBuilder sb = new StringBuilder();
        sb.append(strEffectiveDate);
        sb.insert(4, HYPHEN);
        sb.insert(7, HYPHEN);
        return sb.toString();
    }

    public static Date getyyyy_MM_dd() {
        Date getyyyy_MM_dd = DateUtils.getyyyy_MM_dd(new Date());
        return getyyyy_MM_dd;
    }

    static {
        sdfDate = new SimpleDateFormat("yyyy-MM-dd");
    }
}

