/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.utils.ibot.robot;

import com.alibaba.fastjson2.JSON;
import com.litongjava.utils.httpclient.HttpClientUtils;
import com.litongjava.utils.ibot.robot.AskRequest;
import com.litongjava.utils.ibot.robot.AskResponse;
import com.litongjava.utils.ibot.robot.AskResponseUtil;
import com.litongjava.utils.ibot.robot.HotRequest;
import com.litongjava.utils.string.StringUtils;
import com.litongjava.utils.url.UrlUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RobotHttpClient {
    private static final Logger log = LoggerFactory.getLogger(RobotHttpClient.class);

    public static AskResponse ask(String robotURL, AskRequest data) {
        StringBuffer append = UrlUtils.append(robotURL, "ask.action");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userId", data.getUserId());
        params.put("question", data.getQuestion());
        params.put("sessionId", data.getSessionId());
        params.put("format", data.getFormat());
        params.put("platform", data.getPlatform());
        params.put("location", data.getLocation());
        params.put("brand", data.getBrand());
        String httpResponse = RobotHttpClient.ask(append.toString(), params);
        log.info(httpResponse);
        String format = data.getFormat();
        if (format != null && format.equalsIgnoreCase("json")) {
            AskResponse ap = (AskResponse)JSON.parseObject((String)httpResponse, AskResponse.class);
            if (StringUtils.isEmpty(ap.getProps())) {
                AskResponse.PropsBean props = new AskResponse.PropsBean();
                props.setUserId(data.getUserId());
                props.setSessionId(data.getSessionId());
                ap.setProps(props);
            }
            return ap;
        }
        AskResponse ap = AskResponseUtil.xmlToAskResponse(httpResponse);
        return ap;
    }

    public static String ask(String url, Map<String, Object> params) {
        log.info("url:" + url + ",params:" + params);
        String httpResponse = HttpClientUtils.post(url, null, params);
        return httpResponse;
    }

    public static List<String> getHotQuestion(String robotURL, HotRequest data) {
        if (StringUtils.isEmpty(data.getFormat())) {
            data.setFormat("json");
        }
        String url = UrlUtils.append(robotURL, "p4pages/hot-question.action").toString();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("platform", data.getPlatform());
        params.put("brand", data.getBrand());
        params.put("maxReturn", data.getMaxReturn() + "");
        params.put("type", data.getType() + "");
        params.put("format", data.getFormat());
        String httpResponse = HttpClientUtils.post(url.toString(), null, params);
        List retval = JSON.parseArray((String)httpResponse, String.class);
        return retval;
    }
}

