/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.utils.icepdf;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import org.icepdf.core.exceptions.PDFException;
import org.icepdf.core.exceptions.PDFSecurityException;
import org.icepdf.core.pobjects.Document;

public class IcePdfUtils {
    public static List<File> toImages(String pdfPath, float scale, boolean isOverride) {
        Document document = new Document();
        try {
            document.setFile(pdfPath);
        }
        catch (IOException | PDFException | PDFSecurityException e1) {
            e1.printStackTrace();
            return null;
        }
        ArrayList<File> retval = new ArrayList<File>();
        float rotation = 0.0f;
        for (int i = 0; i < document.getNumberOfPages(); ++i) {
            BufferedImage image;
            String num = i < 9 ? "02" : i + 1 + "";
            File file = new File(pdfPath + "_" + num + ".png");
            retval.add(file);
            if (!file.exists() || !isOverride) continue;
            BufferedImage rendImage = image = (BufferedImage)document.getPageImage(i, 1, 2, rotation, scale);
            try {
                ImageIO.write((RenderedImage)rendImage, "png", file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            image.flush();
        }
        document.dispose();
        return retval;
    }
}

