/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.utils.poi;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class POIExcelExportUtils {
    public static void export(String[] title, String[][] data, File dst) {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet();
        POIExcelExportUtils.setTitle(sheet, title);
        POIExcelExportUtils.setData(sheet, data);
        POIExcelExportUtils.write(dst, wb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void write(File dst, HSSFWorkbook wb) {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(dst);
            wb.write((OutputStream)out);
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                POIExcelExportUtils.closeQuietly(out);
                throw throwable;
            }
            POIExcelExportUtils.closeQuietly(out);
        }
        POIExcelExportUtils.closeQuietly(out);
    }

    private static void setTitle(HSSFSheet sheet, String[] title) {
        HSSFRow row = sheet.createRow(0);
        for (int i = 0; i < title.length; ++i) {
            HSSFCell cell = row.createCell(i);
            cell.setCellValue(title[i]);
        }
    }

    private static void setData(HSSFSheet sheet, String[][] data) {
        for (int i = 0; i < data.length; ++i) {
            HSSFRow row = sheet.createRow(i + 1);
            for (int j = 0; j < data[i].length; ++j) {
                row.createCell(j).setCellValue(data[i][j]);
            }
        }
    }

    public static void closeQuietly(Closeable io) {
        if (io != null) {
            try {
                io.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static <T> void exportForList(LinkedHashMap<String, String> title, List<T> data, File dst) {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet();
        POIExcelExportUtils.setTitle(sheet, title);
        POIExcelExportUtils.setData(sheet, title, data);
        POIExcelExportUtils.write(dst, wb);
    }

    private static <T> void setData(HSSFSheet sheet, LinkedHashMap<String, String> title, List<T> data) {
        for (int i = 0; i < data.size(); ++i) {
            HSSFRow row = sheet.createRow(i + 1);
            T t = data.get(i);
            int j = 0;
            for (Map.Entry<String, String> e : title.entrySet()) {
                HSSFCell cell = row.createCell(j++);
                String key = e.getKey();
                Object value = POIExcelExportUtils.getMethodValue(t, key);
                POIExcelExportUtils.setCellValue(cell, value);
            }
        }
    }

    private static void setCellValue(HSSFCell cell, Object value) {
        if (value instanceof String) {
            cell.setCellValue((String)value);
        } else if (value instanceof Integer) {
            cell.setCellValue((double)((Integer)value).intValue());
        }
    }

    private static <T> Object getMethodValue(T t, String key) {
        String methodName = "get" + key.substring(0, 1).toUpperCase() + key.substring(1);
        Method method = null;
        try {
            method = t.getClass().getDeclaredMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        Object reval = null;
        try {
            reval = method.invoke(t, new Object[0]);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return reval;
    }

    private static void setTitle(HSSFSheet sheet, LinkedHashMap<String, String> title) {
        HSSFRow row = sheet.createRow(0);
        int i = 0;
        for (Map.Entry<String, String> e : title.entrySet()) {
            row.createCell(i++).setCellValue(e.getValue());
        }
    }
}

