/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.httpserver;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.primitives.Ints;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.google.inject.servlet.GuiceFilter;
import com.nesscomputing.galaxy.GalaxyConfig;
import com.nesscomputing.galaxy.GalaxyIp;
import com.nesscomputing.httpserver.HttpServer;
import com.nesscomputing.httpserver.HttpServerConfig;
import com.nesscomputing.lifecycle.Lifecycle;
import com.nesscomputing.lifecycle.LifecycleListener;
import com.nesscomputing.lifecycle.LifecycleStage;
import com.nesscomputing.logging.Log;
import java.util.EnumSet;
import java.util.Set;
import javax.management.MBeanServer;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.server.handler.StatisticsHandler;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.server.ssl.SslSelectChannelConnector;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

public class GalaxyJetty8HttpServer
implements HttpServer {
    private static final Log LOG = Log.findLog();
    private static final EnumSet<DispatcherType> EMPTY_DISPATCHES = EnumSet.noneOf(DispatcherType.class);
    private final HttpServerConfig httpServerConfig;
    private final GalaxyConfig galaxyConfig;
    private final Servlet catchallServlet;
    private MBeanServer mbeanServer = null;
    private Set<Handler> handlers = null;
    private Set<Handler> loggingHandlers = null;
    private HandlerWrapper securityHandler = null;
    private GuiceFilter guiceFilter = null;
    private Server server = null;
    private Connector internalHttpConnector = null;
    private Connector externalHttpConnector = null;
    private Connector internalHttpsConnector = null;
    private Connector externalHttpsConnector = null;

    @Inject
    public GalaxyJetty8HttpServer(HttpServerConfig httpServerConfig, GalaxyConfig galaxyConfig, @Named(value="_catchall") Servlet catchallServlet) {
        this.httpServerConfig = httpServerConfig;
        this.galaxyConfig = galaxyConfig;
        this.catchallServlet = catchallServlet;
    }

    @Inject(optional=true)
    void setGuiceFilter(GuiceFilter guiceFilter) {
        this.guiceFilter = guiceFilter;
    }

    @Inject(optional=true)
    void setMBeanServer(MBeanServer mbeanServer) {
        this.mbeanServer = mbeanServer;
    }

    @Inject(optional=true)
    void addHandlers(@Named(value="_handlers") Set<Handler> handlers) {
        this.handlers = handlers;
    }

    @Inject(optional=true)
    void addLoggingHandlers(@Named(value="_logging") Set<Handler> loggingHandlers) {
        this.loggingHandlers = loggingHandlers;
    }

    @Inject(optional=true)
    void setSecurityHandlers(@Named(value="_security") HandlerWrapper securityHandler) {
        this.securityHandler = securityHandler;
    }

    @Inject(optional=true)
    public void setLifecycle(Lifecycle lifecycle) {
        lifecycle.addListener(LifecycleStage.START_STAGE, new LifecycleListener(){

            public void onStage(LifecycleStage lifecycleStage) {
                GalaxyJetty8HttpServer.this.start();
            }
        });
        lifecycle.addListener(LifecycleStage.STOP_STAGE, new LifecycleListener(){

            public void onStage(LifecycleStage lifecycleStage) {
                GalaxyJetty8HttpServer.this.stop();
            }
        });
    }

    @Override
    public void start() {
        Preconditions.checkState((this.server == null ? 1 : 0) != 0, (Object)"Server was already started!");
        Server server = new Server();
        server.setSendServerVersion(false);
        GalaxyIp internalIp = this.galaxyConfig.getInternalIp();
        GalaxyIp externalIp = this.galaxyConfig.getExternalIp();
        if (this.httpServerConfig.getShutdownTimeout() != null) {
            server.setStopAtShutdown(true);
            server.setGracefulShutdown(Ints.saturatedCast((long)this.httpServerConfig.getShutdownTimeout().getMillis()));
        }
        if (this.httpServerConfig.isInternalHttpEnabled()) {
            this.internalHttpConnector = this.getHttpConnector(internalIp, this.httpServerConfig.isInternalHttpForwarded());
            server.addConnector(this.internalHttpConnector);
        }
        if (this.httpServerConfig.isInternalHttpsEnabled()) {
            this.internalHttpsConnector = this.getHttpsConnector(internalIp, this.httpServerConfig.isInternalHttpsForwarded());
            server.addConnector(this.internalHttpsConnector);
        }
        if (this.httpServerConfig.isExternalHttpEnabled()) {
            if (this.httpServerConfig.isInternalHttpEnabled() && StringUtils.equalsIgnoreCase((CharSequence)internalIp.getIp(), (CharSequence)externalIp.getIp()) && internalIp.getHttpPort() == externalIp.getHttpPort()) {
                LOG.warn("Refusing to double-export %s:%d as HTTP", new Object[]{externalIp.getIp(), externalIp.getHttpPort()});
                this.externalHttpConnector = this.internalHttpConnector;
            } else {
                this.externalHttpConnector = this.getHttpConnector(externalIp, this.httpServerConfig.isExternalHttpForwarded());
                server.addConnector(this.externalHttpConnector);
            }
        }
        if (this.httpServerConfig.isExternalHttpsEnabled()) {
            if (this.httpServerConfig.isInternalHttpsEnabled() && StringUtils.equalsIgnoreCase((CharSequence)internalIp.getIp(), (CharSequence)externalIp.getIp()) && internalIp.getHttpsPort() == externalIp.getHttpsPort()) {
                LOG.warn("Refusing to double-export %s:%d as HTTPS", new Object[]{externalIp.getIp(), externalIp.getHttpsPort()});
                this.externalHttpsConnector = this.internalHttpConnector;
            } else {
                this.externalHttpsConnector = this.getHttpsConnector(externalIp, this.httpServerConfig.isExternalHttpsForwarded());
                server.addConnector(this.externalHttpsConnector);
            }
        }
        HandlerCollection handlerCollection = new HandlerCollection();
        if (this.handlers != null) {
            for (Handler handler : this.handlers) {
                handlerCollection.addHandler(handler);
            }
        }
        handlerCollection.addHandler((Handler)this.createGuiceContext());
        if (this.loggingHandlers != null) {
            for (Handler loggingHandler : this.loggingHandlers) {
                handlerCollection.addHandler(loggingHandler);
            }
        }
        StatisticsHandler statsHandler = new StatisticsHandler();
        if (this.securityHandler == null) {
            statsHandler.setHandler((Handler)handlerCollection);
        } else {
            LOG.info("Enabling security handler (%s)", new Object[]{this.securityHandler.getClass().getName()});
            this.securityHandler.setHandler((Handler)handlerCollection);
            statsHandler.setHandler((Handler)this.securityHandler);
        }
        server.setHandler((Handler)statsHandler);
        QueuedThreadPool threadPool = new QueuedThreadPool(this.httpServerConfig.getMaxThreads());
        threadPool.setMinThreads(this.httpServerConfig.getMinThreads());
        threadPool.setMaxIdleTimeMs(this.httpServerConfig.getThreadMaxIdletime());
        server.setThreadPool((ThreadPool)threadPool);
        if (this.mbeanServer != null && this.httpServerConfig.isJmxEnabled()) {
            MBeanContainer mbeanContainer = new MBeanContainer(this.mbeanServer){

                public void doStart() {
                }
            };
            server.getContainer().addEventListener((Container.Listener)mbeanContainer);
        }
        this.server = server;
        try {
            server.start();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
        Preconditions.checkState((boolean)server.isRunning(), (Object)"Server did not start");
    }

    @Override
    public void stop() {
        Preconditions.checkNotNull((Object)this.server, (Object)"Server was never started!");
        try {
            this.server.stop();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
        Preconditions.checkState((boolean)this.server.isStopped(), (Object)"Server did not stop");
        this.server = null;
    }

    private Connector getHttpConnector(GalaxyIp ipInfo, boolean forwarded) {
        SelectChannelConnector httpConnector = new SelectChannelConnector();
        httpConnector.setPort(ipInfo.getHttpPort());
        httpConnector.setHost(ipInfo.getIp());
        httpConnector.setForwarded(forwarded);
        this.configureConnector(httpConnector);
        return httpConnector;
    }

    private Connector getHttpsConnector(GalaxyIp ipInfo, boolean forwarded) {
        SslContextFactory sslContextFactory = new SslContextFactory(SslContextFactory.DEFAULT_KEYSTORE_PATH);
        if (this.httpServerConfig.getSSLKeystorePath() != null) {
            sslContextFactory.setKeyStoreType(this.httpServerConfig.getSSLKeystoreType());
            sslContextFactory.setKeyStorePath(this.httpServerConfig.getSSLKeystorePath());
            sslContextFactory.setKeyStorePassword(this.httpServerConfig.getSSLKeystorePassword());
        }
        SslSelectChannelConnector httpsConnector = new SslSelectChannelConnector(sslContextFactory);
        httpsConnector.setPort(ipInfo.getHttpsPort());
        httpsConnector.setHost(ipInfo.getIp());
        httpsConnector.setForwarded(forwarded);
        this.configureConnector((SelectChannelConnector)httpsConnector);
        return httpsConnector;
    }

    private void configureConnector(SelectChannelConnector connector) {
        connector.setMaxIdleTime(this.httpServerConfig.getMaxIdletime());
        connector.setStatsOn(true);
        connector.setResponseHeaderSize(this.httpServerConfig.getResponseHeaderSize());
    }

    private ServletContextHandler createGuiceContext() {
        ServletContextHandler context = new ServletContextHandler(0);
        if (this.guiceFilter != null) {
            FilterHolder filterHolder = new FilterHolder((Filter)this.guiceFilter);
            context.addFilter(filterHolder, "/*", EMPTY_DISPATCHES);
        }
        ServletHolder servletHolder = new ServletHolder(this.catchallServlet);
        context.addServlet(servletHolder, "/*");
        return context;
    }

    @Override
    public int getInternalHttpPort() {
        return this.internalHttpConnector == null ? -1 : this.internalHttpConnector.getLocalPort();
    }

    @Override
    public int getInternalHttpsPort() {
        return this.internalHttpsConnector == null ? -1 : this.internalHttpsConnector.getLocalPort();
    }

    @Override
    public int getExternalHttpPort() {
        return this.externalHttpConnector == null ? -1 : this.externalHttpConnector.getLocalPort();
    }

    @Override
    public int getExternalHttpsPort() {
        return this.externalHttpsConnector == null ? -1 : this.externalHttpsConnector.getLocalPort();
    }

    @Override
    public String getInternalAddress() {
        return this.internalHttpConnector == null ? null : (String)Objects.firstNonNull((Object)this.internalHttpConnector.getHost(), (Object)"");
    }

    @Override
    public String getExternalAddress() {
        return this.externalHttpConnector == null ? null : (String)Objects.firstNonNull((Object)this.externalHttpConnector.getHost(), (Object)"");
    }
}

