/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.httpserver;

import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import com.nesscomputing.config.Config;
import com.nesscomputing.config.ConfigModule;
import com.nesscomputing.galaxy.GalaxyConfigModule;
import com.nesscomputing.httpserver.HttpConnector;
import com.nesscomputing.httpserver.HttpServer;
import com.nesscomputing.httpserver.HttpServerModule;
import com.nesscomputing.lifecycle.junit.LifecycleRule;
import com.nesscomputing.lifecycle.junit.LifecycleRunner;
import com.nesscomputing.lifecycle.junit.LifecycleStatement;
import com.nesscomputing.testing.lessio.AllowNetworkListen;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@AllowNetworkListen(ports={0})
@RunWith(value=LifecycleRunner.class)
public class TestNullPort {
    @LifecycleRule
    public final LifecycleStatement lifecycleRule = LifecycleStatement.serviceDiscoveryLifecycle();
    @Inject
    private HttpServer server = null;

    @Before
    public void setUp() {
        Config config = Config.getFixedConfig((String[])new String[]{"galaxy.internal.port.http", "0"});
        Injector injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{new ConfigModule(config), new HttpServerModule(config), new GalaxyConfigModule(), this.lifecycleRule.getLifecycleModule(), new Module(){

            public void configure(Binder binder) {
                binder.requireExplicitBindings();
                binder.disableCircularProxies();
            }
        }});
        injector.injectMembers((Object)this);
    }

    @Test
    public void testSimple() throws Exception {
        Assert.assertNotNull((Object)this.server);
        HttpConnector httpConnector = (HttpConnector)this.server.getConnectors().get("internal-http");
        Assert.assertTrue((httpConnector.getPort() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((httpConnector.getPort() != 8080 ? 1 : 0) != 0);
        Assert.assertTrue((httpConnector.getPort() != 80 ? 1 : 0) != 0);
    }
}

