/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.httpserver.jetty;

import com.nesscomputing.httpclient.HttpClient;
import com.nesscomputing.httpclient.HttpClientResponse;
import com.nesscomputing.httpclient.HttpClientResponseHandler;
import com.nesscomputing.httpclient.response.ContentConverter;
import com.nesscomputing.httpclient.response.ContentResponseHandler;
import com.nesscomputing.httpclient.response.StringContentConverter;
import com.nesscomputing.httpclient.response.Valid2xxContentConverter;
import com.nesscomputing.httpserver.jetty.ClasspathResourceHandler;
import com.nesscomputing.httpserver.testing.LocalHttpService;
import com.nesscomputing.testing.lessio.AllowNetworkAccess;
import com.nesscomputing.testing.lessio.AllowNetworkListen;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jetty.server.Handler;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@AllowNetworkListen(ports={0})
@AllowNetworkAccess(endpoints={"127.0.0.1:*"})
public class TestClasspathResourceHandler {
    private Handler testHandler = null;
    private LocalHttpService localHttpService = null;
    private HttpClient httpClient = null;
    private String baseUri;

    @Before
    public void setup() {
        Assert.assertNull((Object)this.localHttpService);
        Assert.assertNull((Object)this.testHandler);
        this.testHandler = new ClasspathResourceHandler("", "/test-resources");
        this.localHttpService = LocalHttpService.forHandler((Handler)this.testHandler);
        this.localHttpService.start();
        this.httpClient = new HttpClient().start();
        this.baseUri = "http://" + this.localHttpService.getHost() + ":" + this.localHttpService.getPort();
    }

    @After
    public void teardown() {
        Assert.assertNotNull((Object)this.localHttpService);
        Assert.assertNotNull((Object)this.testHandler);
        this.localHttpService.stop();
        this.localHttpService = null;
        this.testHandler = null;
        Assert.assertNotNull((Object)this.httpClient);
        this.httpClient.close();
        this.httpClient = null;
        this.baseUri = null;
    }

    @Test
    public void testSimpleGet() throws Exception {
        String content = (String)this.httpClient.get(this.baseUri + "/simple-content.txt", (HttpClientResponseHandler)StringContentConverter.DEFAULT_RESPONSE_HANDLER).perform();
        Assert.assertEquals((Object)"this is simple content for a simple test\n", (Object)content);
    }

    @Test
    public void testSimpleHead() throws Exception {
        String content = (String)this.httpClient.head(this.baseUri + "/simple-content.txt", (HttpClientResponseHandler)StringContentConverter.DEFAULT_RESPONSE_HANDLER).perform();
        Assert.assertEquals((Object)"", (Object)content);
    }

    @Test
    public void testSimplePost() throws Exception {
        ContentResponseHandler responseHandler = ContentResponseHandler.forConverter((ContentConverter)new StringContentConverter(){

            public String convert(HttpClientResponse response, InputStream inputStream) throws IOException {
                Assert.assertEquals((long)405L, (long)response.getStatusCode());
                return null;
            }
        });
        String content = (String)this.httpClient.post(this.baseUri + "/simple-content.txt", (HttpClientResponseHandler)responseHandler).perform();
        Assert.assertEquals(null, (Object)content);
    }

    @Test
    public void testMissing() throws Exception {
        ContentResponseHandler responseHandler = new ContentResponseHandler((ContentConverter)new StringContentConverter(){

            public String convert(HttpClientResponse response, InputStream inputStream) throws IOException {
                Assert.assertEquals((long)404L, (long)response.getStatusCode());
                return null;
            }
        });
        String content = (String)this.httpClient.get(this.baseUri + "/missing", (HttpClientResponseHandler)responseHandler).perform();
        Assert.assertNull((Object)content);
    }

    @Test
    public void testIfModified() throws Exception {
        final AtomicReference<Object> holder = new AtomicReference<Object>(null);
        ContentResponseHandler responseHandler = new ContentResponseHandler((ContentConverter)new StringContentConverter(){

            public String convert(HttpClientResponse response, InputStream inputStream) throws IOException {
                holder.set(response.getHeader("Last-Modified"));
                return super.convert(response, inputStream);
            }
        });
        String uri = this.baseUri + "/simple-content.txt";
        String content = (String)this.httpClient.get(uri, (HttpClientResponseHandler)responseHandler).perform();
        Assert.assertNotNull(holder.get());
        Assert.assertEquals((Object)"this is simple content for a simple test\n", (Object)content);
        ContentResponseHandler responseHandler2 = new ContentResponseHandler((ContentConverter)new StringContentConverter(){

            public String convert(HttpClientResponse response, InputStream inputStream) throws IOException {
                Assert.assertEquals((long)304L, (long)response.getStatusCode());
                return null;
            }
        });
        String content2 = (String)this.httpClient.get(uri, (HttpClientResponseHandler)responseHandler2).addHeader("If-Modified-Since", (String)holder.get()).perform();
        Assert.assertNull((Object)content2);
        DateTimeFormatter httpFormat = DateTimeFormat.forPattern((String)"EEE, dd MMM YYYY HH:mm:ss");
        long newModified = httpFormat.parseMillis(StringUtils.removeEnd((String)holder.get(), (String)" GMT")) - 600000L;
        this.httpClient.get(uri, (HttpClientResponseHandler)Valid2xxContentConverter.DEFAULT_FAILING_RESPONSE_HANDLER).addHeader("If-Modified-Since", httpFormat.print(newModified) + " GMT").perform();
    }

    @Test
    public void testWelcomeFile1() throws Exception {
        String content = (String)this.httpClient.get(this.baseUri + "/", (HttpClientResponseHandler)StringContentConverter.DEFAULT_RESPONSE_HANDLER).perform();
        Assert.assertTrue((boolean)content.endsWith("the welcome file\n"));
    }

    @Test
    public void testWelcomeFile2() throws Exception {
        String content = (String)this.httpClient.get(this.baseUri, (HttpClientResponseHandler)StringContentConverter.DEFAULT_RESPONSE_HANDLER).perform();
        Assert.assertTrue((boolean)content.endsWith("the welcome file\n"));
    }

    @Test
    public void testWelcomeFile3() throws Exception {
        String content = (String)this.httpClient.get(this.baseUri + "/index.html", (HttpClientResponseHandler)StringContentConverter.DEFAULT_RESPONSE_HANDLER).perform();
        Assert.assertTrue((boolean)content.endsWith("the welcome file\n"));
    }
}

