/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.httpserver.log.file;

import com.google.inject.Binder;
import com.google.inject.CreationException;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Stage;
import com.nesscomputing.config.Config;
import com.nesscomputing.httpserver.log.LogFieldsModule;
import com.nesscomputing.httpserver.log.file.FileRequestLog;
import com.nesscomputing.httpserver.log.file.FileRequestLogModule;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.servlet.http.Cookie;
import org.easymock.EasyMock;
import org.easymock.EasyMockSupport;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.joda.time.DateTimeUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class FileRequestLogTest
extends EasyMockSupport {
    @Inject
    private FileRequestLog fileRequestLog;

    @After
    public void tearDown() {
        DateTimeUtils.setCurrentMillisSystem();
    }

    @Test
    public void testRequestLogging() {
        Config config = Config.getFixedConfig((String[])new String[]{"ness.httpserver.request-log.file.enabled", "true", "ness.httpserver.request-log.file.fields", "remoteAddr,cookie:trumpet-json-api-authorization,cookie:not-here,method,requestUri,query,responseCode,responseHeader:Content-Length,elapsedTime"});
        Injector inj = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{this.disableStuff(), new LogFieldsModule(), new FileRequestLogModule(config)});
        inj.injectMembers((Object)this);
        Assert.assertNotNull((Object)this.fileRequestLog);
        StringWriter buffer = new StringWriter();
        this.fileRequestLog.setWriter(new PrintWriter(buffer));
        Request req = (Request)this.createMock(Request.class);
        Response resp = (Response)this.createMock(Response.class);
        EasyMock.expect((Object)req.getRemoteAddr()).andReturn((Object)"1.2.3.4").anyTimes();
        Cookie[] cookies = new Cookie[]{new Cookie("trumpet-JSON-api-AUTHORIZATION", "omgwtfbbq")};
        EasyMock.expect((Object)req.getCookies()).andReturn((Object)cookies).anyTimes();
        EasyMock.expect((Object)req.getMethod()).andReturn((Object)"GET").anyTimes();
        EasyMock.expect((Object)req.getRequestURI()).andReturn((Object)"foo").anyTimes();
        EasyMock.expect((Object)req.getRequestURL()).andReturn((Object)new StringBuffer("foo")).anyTimes();
        EasyMock.expect((Object)req.getQueryString()).andReturn((Object)"?bar").anyTimes();
        EasyMock.expect((Object)req.getTimeStamp()).andReturn((Object)10000L).anyTimes();
        EasyMock.expect((Object)resp.getStatus()).andReturn((Object)201).anyTimes();
        EasyMock.expect((Object)resp.getHeader("Content-Length")).andReturn((Object)"42").anyTimes();
        this.replayAll();
        DateTimeUtils.setCurrentMillisFixed((long)11500L);
        this.fileRequestLog.log(req, resp);
        Assert.assertEquals((Object)"1.2.3.4\tomgwtfbbq\t\tGET\tfoo\t?bar\t201\t42\t1500\n", (Object)buffer.getBuffer().toString());
        this.verifyAll();
    }

    @Test
    public void testNullCookies() {
        Config config = Config.getFixedConfig((String[])new String[]{"ness.httpserver.request-log.file.enabled", "true", "ness.httpserver.request-log.file.fields", "remoteAddr,cookie:trumpet-json-api-authorization,method,requestUri,query,responseCode,responseHeader:Content-Length"});
        Injector inj = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{this.disableStuff(), new LogFieldsModule(), new FileRequestLogModule(config)});
        inj.injectMembers((Object)this);
        Assert.assertNotNull((Object)this.fileRequestLog);
        StringWriter buffer = new StringWriter();
        this.fileRequestLog.setWriter(new PrintWriter(buffer));
        Request req = (Request)this.createMock(Request.class);
        Response resp = (Response)this.createMock(Response.class);
        EasyMock.expect((Object)req.getRemoteAddr()).andReturn((Object)"1.2.3.4").anyTimes();
        EasyMock.expect((Object)req.getCookies()).andReturn(null).anyTimes();
        EasyMock.expect((Object)req.getMethod()).andReturn((Object)"GET").anyTimes();
        EasyMock.expect((Object)req.getRequestURL()).andReturn((Object)new StringBuffer("foo")).anyTimes();
        EasyMock.expect((Object)req.getRequestURI()).andReturn((Object)"foo").anyTimes();
        EasyMock.expect((Object)req.getQueryString()).andReturn((Object)"?bar").anyTimes();
        EasyMock.expect((Object)resp.getStatus()).andReturn((Object)201).anyTimes();
        EasyMock.expect((Object)resp.getHeader("Content-Length")).andReturn((Object)"42").anyTimes();
        this.replayAll();
        this.fileRequestLog.log(req, resp);
        Assert.assertEquals((Object)"1.2.3.4\t\tGET\tfoo\t?bar\t201\t42\n", (Object)buffer.getBuffer().toString());
        this.verifyAll();
    }

    @Test
    public void testInvalidLogPatternBadSpecifier() {
        Config config = Config.getFixedConfig((String[])new String[]{"ness.httpserver.request-log.file.enabled", "true", "ness.httpserver.request-log.file.fields", "remoteAddr,foo"});
        try {
            Injector inj = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{this.disableStuff(), new LogFieldsModule(), new FileRequestLogModule(config)});
            inj.injectMembers((Object)this);
            Assert.fail();
        }
        catch (CreationException ce) {
            Assert.assertEquals(IllegalArgumentException.class, ce.getCause().getClass());
            Assert.assertEquals((Object)"Invalid log pattern: unknown field <foo>", (Object)ce.getCause().getMessage());
        }
    }

    @Test
    public void testInvalidLogPatternTooManyColons() {
        try {
            Config config = Config.getFixedConfig((String[])new String[]{"ness.httpserver.request-log.file.enabled", "true", "ness.httpserver.request-log.file.fields", "remoteAddr,cookie:no-here:bar"});
            Injector inj = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{this.disableStuff(), new LogFieldsModule(), new FileRequestLogModule(config)});
            inj.injectMembers((Object)this);
            Assert.fail();
        }
        catch (CreationException ce) {
            Assert.assertEquals(IllegalArgumentException.class, ce.getCause().getClass());
            Assert.assertEquals((Object)"Bad specifier \"cookie:no-here:bar\" has too many colons", (Object)ce.getCause().getMessage());
        }
    }

    @Test
    public void testDefaultConfigWorks() {
        Config config = Config.getFixedConfig((String[])new String[]{"ness.httpserver.request-log.file.enabled", "true"});
        Injector inj = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{this.disableStuff(), new LogFieldsModule(), new FileRequestLogModule(config)});
        inj.injectMembers((Object)this);
        Assert.assertNotNull((Object)this.fileRequestLog);
    }

    @Test
    public void testDisabledByDefault() {
        Config config = Config.getEmptyConfig();
        Injector inj = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{this.disableStuff(), new LogFieldsModule(), new FileRequestLogModule(config)});
        Assert.assertNull((Object)inj.getExistingBinding(Key.get(FileRequestLog.class)));
    }

    private Module disableStuff() {
        return new Module(){

            public void configure(Binder binder) {
                binder.disableCircularProxies();
                binder.requireExplicitBindings();
            }
        };
    }
}

