/*
 * Decompiled with CFR 0.152.
 */
package com.qencode.api.java.client;

import com.qencode.api.java.client.QencodeException;
import com.qencode.api.java.client.classes.TranscodingTask;
import com.qencode.api.java.client.helpers.QueryStringBuilder;
import com.qencode.api.java.client.response.AccessTokenResponse;
import com.qencode.api.java.client.response.CreateTaskResponse;
import com.qencode.api.java.client.response.QencodeApiResponse;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import jdk.nashorn.internal.objects.NativeString;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.PropertyNamingStrategy;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

public class QencodeApiClient {
    public static final String API_URL = "https://api.qencode.com/v1";
    private String key;
    private String url;
    private String accessToken;
    private RestTemplate rt;
    private ObjectMapper mapper;
    private String lastResponseRaw;

    public String getAccessToken() {
        return this.accessToken;
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    public QencodeApiClient(String api_key) throws UnsupportedEncodingException, QencodeException {
        this.key = api_key;
        this.url = API_URL;
        this.rt = new RestTemplate();
        this.mapper = this.createObjectMapper();
        this.requestAccessToken();
    }

    public QencodeApiClient(String api_key, String url) throws UnsupportedEncodingException, QencodeException {
        this.key = api_key;
        this.url = API_URL;
        if (!QencodeApiClient.isEmpty(url)) {
            this.url = url;
        }
        this.rt = new RestTemplate();
        this.mapper = this.createObjectMapper();
        this.requestAccessToken();
    }

    private ObjectMapper createObjectMapper() {
        ObjectMapper m = new ObjectMapper();
        m.configure(SerializationConfig.Feature.WRITE_NULL_PROPERTIES, false);
        m.configure(SerializationConfig.Feature.WRITE_ENUMS_USING_TO_STRING, true);
        m.configure(DeserializationConfig.Feature.READ_ENUMS_USING_TO_STRING, true);
        m.setPropertyNamingStrategy(PropertyNamingStrategy.CAMEL_CASE_TO_LOWER_CASE_WITH_UNDERSCORES);
        m.setSerializationInclusion(JsonSerialize.Inclusion.NON_DEFAULT);
        m.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return m;
    }

    public String getApiKey() {
        return this.key;
    }

    public void setApiKey(String api_key) {
        this.key = api_key;
    }

    public String getApiUrl() {
        return this.url;
    }

    public void setApiUrl(String api_url) {
        this.url = api_url;
    }

    public RestTemplate getRestTemplate() {
        return this.rt;
    }

    public void setRestTemplate(RestTemplate rt) {
        this.rt = rt;
    }

    private HttpHeaders getHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/x-www-form-urlencoded");
        headers.add("User-Agent", "Qencode Java API SDK 1.0");
        return headers;
    }

    private void requestAccessToken() throws QencodeException, UnsupportedEncodingException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("api_key", this.key);
        String responseStr = this.Request("access_token", params);
        try {
            AccessTokenResponse response = (AccessTokenResponse)this.mapper.readValue(responseStr, AccessTokenResponse.class);
            this.accessToken = response.getToken();
        }
        catch (Exception e) {
            throw new QencodeException("Unable to deserialize Response as JSON", e);
        }
    }

    public String getLastResponseRaw() {
        return this.lastResponseRaw;
    }

    public String Request(String path, Map<String, String> parameters) throws QencodeException, UnsupportedEncodingException {
        String queryParams = QueryStringBuilder.BuildQueryString(parameters);
        return this.Request(path, queryParams);
    }

    public String Request(String path, String parameters) throws QencodeException {
        this.lastResponseRaw = null;
        String requestUrl = null;
        requestUrl = path.toLowerCase().indexOf("http") == 0 ? path : this.url + "/" + QencodeApiClient.trim(path, '/');
        try {
            this.lastResponseRaw = this.HttpPost(requestUrl, parameters);
        }
        catch (Exception e) {
            throw new QencodeException("Error executing request to url: " + requestUrl, e);
        }
        QencodeApiResponse response = null;
        try {
            response = (QencodeApiResponse)this.mapper.readValue(this.lastResponseRaw, QencodeApiResponse.class);
        }
        catch (Exception e) {
            throw new QencodeException("Unable to deserialize Response as JSON", e);
        }
        if (response == null || response.getError() == -1) {
            throw new QencodeException("Invalid API response: " + this.lastResponseRaw);
        }
        if (response.getError() != 0) {
            throw new QencodeException(response.getMessage());
        }
        return this.lastResponseRaw;
    }

    private String HttpPost(String url, String requestBody) throws QencodeException {
        HttpHeaders headers = this.getHeaders();
        HttpEntity entity = new HttpEntity((Object)requestBody, (MultiValueMap)headers);
        ResponseEntity response = null;
        try {
            response = this.rt.exchange(url, HttpMethod.POST, entity, String.class, new HashMap());
        }
        catch (HttpClientErrorException hcee) {
            throw new QencodeException(hcee.getResponseBodyAsString(), hcee);
        }
        return (String)response.getBody();
    }

    private static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    private static String trim(String s, char c) {
        int st;
        int len = s.length();
        char[] val = s.toCharArray();
        for (st = 0; st < len && val[st] <= c; ++st) {
        }
        while (st < len && val[len - 1] <= c) {
            --len;
        }
        return st > 0 || len < s.length() ? NativeString.substring((Object)st, (int)len) : s;
    }

    public TranscodingTask CreateTask() throws UnsupportedEncodingException, QencodeException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("token", this.accessToken);
        String responseStr = this.Request("create_task", params);
        CreateTaskResponse response = null;
        try {
            response = (CreateTaskResponse)this.mapper.readValue(responseStr, CreateTaskResponse.class);
        }
        catch (Exception e) {
            throw new QencodeException("Unable to deserialize CreateTaskResponse as JSON", e);
        }
        return new TranscodingTask(this, response.getTaskToken());
    }
}

