/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.utility.functions;

import com.scriptbasic.Function;
import com.scriptbasic.classification.Constant;
import com.scriptbasic.classification.String;
import com.scriptbasic.classification.System;
import com.scriptbasic.classification.Utility;
import com.scriptbasic.executors.rightvalues.BasicArrayValue;
import com.scriptbasic.interfaces.BasicRuntimeException;
import com.scriptbasic.utility.UtilityUtility;
import java.io.UnsupportedEncodingException;

public class UtilityFunctions {
    private UtilityFunctions() {
        UtilityUtility.throwExceptionToEnsureNobodyCallsIt();
    }

    @Function(alias="new", classification={System.class})
    public static Object newObject(java.lang.String klass) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        return Class.forName(klass).newInstance();
    }

    @Function(classification={Constant.class})
    public static Object undef() {
        return null;
    }

    @Function(classification={Constant.class})
    public static Boolean isUndef(Object s) {
        return s == null;
    }

    @Function(classification={Constant.class})
    public static Boolean isDefined(Object s) {
        return s != null;
    }

    @Function(classification={Utility.class})
    public static byte[] byteBuffer(int len) {
        return new byte[len];
    }

    @Function(classification={Utility.class})
    public static Long getByte(byte[] buffer, Long i) {
        if (i < 0L || i >= (long)buffer.length) {
            return null;
        }
        return new Long(buffer[i.intValue()]);
    }

    @Function(classification={Utility.class})
    public static void setByte(byte[] buffer, Long i, Long v) throws BasicRuntimeException {
        if (v < 0L && v > -128L) {
            v = v + 128L;
        }
        if (v < 0L || v > 255L) {
            throw new BasicRuntimeException("Byte value is out of range.");
        }
        if (i < 0L && i >= (long)buffer.length) {
            throw new BasicRuntimeException("Index out of range indexing a byte array from BASIC");
        }
        buffer[i.intValue()] = (byte)v.intValue();
    }

    @Function(classification={Utility.class})
    public static byte[] getStringBytes(java.lang.String s) throws UnsupportedEncodingException {
        return s.getBytes("utf-8");
    }

    @Function(classification={Utility.class, String.class})
    public static java.lang.String stringifyBuffer(byte[] buffer) throws UnsupportedEncodingException {
        return new java.lang.String(buffer, "utf-8");
    }

    @Function(classification={Utility.class}, requiredVersion=2L)
    public static Long length(Object arg) {
        if (arg instanceof BasicArrayValue) {
            BasicArrayValue array = (BasicArrayValue)arg;
            return array.getLength();
        }
        if (arg instanceof java.lang.String) {
            java.lang.String string = (java.lang.String)arg;
            return new Long(string.length());
        }
        if (arg instanceof byte[]) {
            byte[] byteArray = (byte[])arg;
            return new Long(byteArray.length);
        }
        return null;
    }
}

