/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic;

import com.scriptbasic.api.Configuration;
import com.scriptbasic.api.ScriptBasic;
import com.scriptbasic.api.ScriptBasicException;
import com.scriptbasic.api.Subroutine;
import com.scriptbasic.context.Context;
import com.scriptbasic.context.ContextBuilder;
import com.scriptbasic.errors.BasicInterpreterInternalError;
import com.scriptbasic.executors.commands.CommandSub;
import com.scriptbasic.interfaces.AnalysisException;
import com.scriptbasic.readers.SourcePath;
import com.scriptbasic.readers.SourceProvider;
import com.scriptbasic.readers.SourceReader;
import com.scriptbasic.sourceproviders.BasicSourcePath;
import com.scriptbasic.sourceproviders.FileSourceProvider;
import com.scriptbasic.spi.InterpreterHook;
import com.scriptbasic.utility.RightValueUtility;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class Engine
implements ScriptBasic {
    private final Map<String, Subroutine> subroutines = new HashMap<String, Subroutine>();
    private Reader input;
    private Writer output;
    private Writer error;
    private boolean theMapHasToBeFilled = true;
    private Context ctx;

    @Override
    public Reader getInput() {
        return this.input;
    }

    @Override
    public void setInput(Reader input) {
        this.input = input;
    }

    @Override
    public Writer getOutput() {
        return this.output;
    }

    @Override
    public void setOutput(Writer output) {
        this.output = output;
    }

    @Override
    public Writer getErrorOutput() {
        return this.error;
    }

    @Override
    public void setErrorOutput(Writer error) {
        this.error = error;
    }

    private void loadHelper(Reader reader) throws ScriptBasicException {
        this.loadHelper(reader, null);
    }

    private void loadHelper(String fileName, SourceProvider sourceProvider) throws ScriptBasicException {
        try {
            SourceReader sourceReader = sourceProvider.get(fileName);
            this.loadHelper(sourceReader);
        }
        catch (IOException e) {
            throw new ScriptBasicException(e);
        }
    }

    private void loadHelper(Reader reader, String fileName) throws ScriptBasicException {
        try {
            this.ctx = ContextBuilder.from(this.ctx, reader, this.input, this.output, this.error);
            this.ctx.interpreter.setProgram(this.ctx.syntaxAnalyzer.analyze());
        }
        catch (AnalysisException e) {
            throw new ScriptBasicException(e);
        }
    }

    private void loadHelper(SourceReader sourceReader) throws ScriptBasicException {
        try {
            this.ctx = ContextBuilder.from(this.ctx, sourceReader, this.input, this.output, this.error);
            this.ctx.interpreter.setProgram(this.ctx.syntaxAnalyzer.analyze());
        }
        catch (AnalysisException e) {
            throw new ScriptBasicException(e);
        }
    }

    @Override
    public ScriptBasic execute() throws ScriptBasicException {
        this.assertCtxInitialized();
        this.ctx.interpreter.execute();
        return this;
    }

    private void assertCtxInitialized() throws ScriptBasicException {
        if (this.ctx == null) {
            throw new ScriptBasicException("Interpreter was not properly initialized.");
        }
    }

    @Override
    public ScriptBasic load(String sourceCode) throws ScriptBasicException {
        this.loadHelper(new StringReader(sourceCode));
        return this;
    }

    @Override
    public ScriptBasic eval(String sourceCode) throws ScriptBasicException {
        this.load(sourceCode);
        this.execute();
        return this;
    }

    @Override
    public ScriptBasic load(Reader reader) throws ScriptBasicException {
        this.loadHelper(reader);
        return this;
    }

    @Override
    public ScriptBasic eval(Reader reader) throws ScriptBasicException {
        this.load(reader);
        this.execute();
        return this;
    }

    @Override
    public ScriptBasic load(File sourceFile) throws ScriptBasicException {
        try {
            this.loadHelper(new FileReader(sourceFile), sourceFile.getAbsolutePath());
        }
        catch (FileNotFoundException e) {
            throw new ScriptBasicException(e);
        }
        return this;
    }

    @Override
    public ScriptBasic eval(File sourceFile) throws ScriptBasicException {
        this.load(sourceFile);
        this.execute();
        return this;
    }

    @Override
    public ScriptBasic load(String sourceFileName, String ... path) throws ScriptBasicException {
        FileSourceProvider sourceProvider = new FileSourceProvider();
        BasicSourcePath sourcePath = new BasicSourcePath();
        for (String p : path) {
            sourcePath.add(p);
        }
        sourceProvider.setSourcePath(sourcePath);
        this.loadHelper(sourceFileName, sourceProvider);
        return this;
    }

    @Override
    public ScriptBasic eval(String sourceFileName, String ... path) throws ScriptBasicException {
        this.load(sourceFileName, path);
        this.execute();
        return this;
    }

    @Override
    public ScriptBasic load(String sourceFileName, SourcePath path) throws ScriptBasicException {
        FileSourceProvider sourceProvider = new FileSourceProvider();
        sourceProvider.setSourcePath(path);
        this.loadHelper(sourceFileName, sourceProvider);
        return this;
    }

    @Override
    public ScriptBasic eval(String sourceFileName, SourcePath path) throws ScriptBasicException {
        this.load(sourceFileName, path);
        this.execute();
        return this;
    }

    @Override
    public ScriptBasic load(String sourceName, SourceProvider provider) throws ScriptBasicException {
        this.loadHelper(sourceName, provider);
        return this;
    }

    @Override
    public ScriptBasic eval(String sourceName, SourceProvider provider) throws ScriptBasicException {
        this.load(sourceName, provider);
        this.execute();
        return this;
    }

    @Override
    public void setVariable(String name, Object value) throws ScriptBasicException {
        this.ctx = ContextBuilder.from(this.ctx);
        this.ctx.interpreter.getVariables().setVariable(name, RightValueUtility.createRightValue(value));
    }

    @Override
    public Object getVariable(String name) throws ScriptBasicException {
        return this.variable(Object.class, name);
    }

    @Override
    public <T> T variable(Class<T> type, String name) throws ScriptBasicException {
        this.assertCtxInitialized();
        Object result = this.ctx.interpreter.getVariable(name);
        if (result == null || type.isAssignableFrom(result.getClass())) {
            return (T)result;
        }
        throw new ScriptBasicException("Fetching the variable '" + name + "' casting to type " + type.getName() + " failed from " + result.getClass().getName());
    }

    @Override
    public Iterable<String> getVariablesIterator() throws ScriptBasicException {
        return this.variables();
    }

    @Override
    public Iterable<String> variables() throws ScriptBasicException {
        this.assertCtxInitialized();
        return this.ctx.interpreter.getVariables().getGlobalMap().getVariableNameSet();
    }

    private void SNAFU_SubroutineDoesNotExist(Exception e) {
        throw new BasicInterpreterInternalError("An already located subroutine does not exist", e);
    }

    @Override
    public Iterable<Subroutine> subroutines() throws ScriptBasicException {
        if (this.theMapHasToBeFilled) {
            this.assertCtxInitialized();
            for (String s : this.ctx.interpreter.getProgram().getNamedCommandNames()) {
                try {
                    this.subroutine((Class)Object.class, s);
                }
                catch (ScriptBasicException e) {
                    this.SNAFU_SubroutineDoesNotExist(e);
                }
            }
            this.theMapHasToBeFilled = false;
        }
        return this.subroutines.values();
    }

    private CommandSub getCommandSub(String subroutineName) throws ScriptBasicException {
        this.assertCtxInitialized();
        CommandSub commandSub = this.ctx.interpreter.getSubroutine(subroutineName);
        if (commandSub == null) {
            throw new ScriptBasicException("Sobroutine '" + subroutineName + "' is not defined in the program");
        }
        return commandSub;
    }

    private int getNumberOfArguments(String subroutineName) throws ScriptBasicException {
        CommandSub commandSub = this.getCommandSub(subroutineName);
        int size = commandSub.getArguments() != null ? commandSub.getArguments().size() : 0;
        return size;
    }

    public <R> Subroutine<R> subroutine(String name) throws ScriptBasicException {
        return this.subroutine((Class<R>)null, name);
    }

    public <R> Subroutine<R> subroutine(Class<R> type, String name) throws ScriptBasicException {
        if (this.subroutines.containsKey(name)) {
            return this.subroutines.get(name);
        }
        CommandSub commandSub = this.getCommandSub(name);
        Sub<R> sub = new Sub<R>(type, commandSub.getSubName());
        this.subroutines.put(name, sub);
        return sub;
    }

    @Override
    public void registerFunction(String alias, Class<?> klass, String methodName, Class<?> ... argumentTypes) throws ScriptBasicException {
        this.ctx = ContextBuilder.from(this.ctx);
        this.ctx.interpreter.registerJavaMethod(alias, klass, methodName, argumentTypes);
    }

    @Override
    public ScriptBasic registerExtension(Class<?> klass) {
        this.ctx = ContextBuilder.from(this.ctx);
        this.ctx.interpreter.registerFunctions(klass);
        return this;
    }

    @Override
    public ScriptBasic registerHook(InterpreterHook hook) {
        this.ctx = ContextBuilder.from(this.ctx);
        this.ctx.interpreter.registerHook(hook);
        return this;
    }

    @Override
    public Configuration getConfiguration() {
        this.ctx = ContextBuilder.from(this.ctx);
        return this.ctx.configuration;
    }

    public class Sub<R>
    implements Subroutine<R> {
        private final String name;
        private final Class<R> type;

        Sub(Class<R> t, String n) {
            this.name = n;
            this.type = Objects.requireNonNullElseGet(t, () -> Object.class);
        }

        @Override
        public int numberOfArguments() {
            try {
                return Engine.this.getNumberOfArguments(this.name);
            }
            catch (ScriptBasicException e) {
                Engine.this.SNAFU_SubroutineDoesNotExist(e);
                return 0;
            }
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public R call(Object ... args) throws ScriptBasicException {
            Engine.this.assertCtxInitialized();
            Object result = Engine.this.ctx.interpreter.call(this.name, args);
            if (this.type == Void.class && result != null) {
                throw new ScriptBasicException("Subroutine '" + this.name + "' expected to be Void but returns value of type " + this.type.getName());
            }
            if (result == null || this.type.isAssignableFrom(result.getClass())) {
                return (R)result;
            }
            throw new ScriptBasicException("Fetching the return value of subroutine '" + this.name + "' casting to type " + this.type.getName() + " failed from " + result.getClass().getName());
        }

        @Override
        public R call() throws ScriptBasicException {
            return this.call(null);
        }
    }
}

