/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.syntax.expression;

import com.scriptbasic.context.Context;
import com.scriptbasic.executors.operators.AbstractBinaryOperator;
import com.scriptbasic.executors.operators.AddOperator;
import com.scriptbasic.executors.operators.AmpersandOperator;
import com.scriptbasic.executors.operators.DivideOperator;
import com.scriptbasic.executors.operators.EqualsOperator;
import com.scriptbasic.executors.operators.GreaterOrEqualOperator;
import com.scriptbasic.executors.operators.GreaterThanOperator;
import com.scriptbasic.executors.operators.IntegerDivideOperator;
import com.scriptbasic.executors.operators.JavaObjectFieldAccessOperator;
import com.scriptbasic.executors.operators.LessOrEqualOperator;
import com.scriptbasic.executors.operators.LessThanOperator;
import com.scriptbasic.executors.operators.LogicalAndOperator;
import com.scriptbasic.executors.operators.LogicalOrOperator;
import com.scriptbasic.executors.operators.MinusOperator;
import com.scriptbasic.executors.operators.ModuloOperator;
import com.scriptbasic.executors.operators.MultiplyOperator;
import com.scriptbasic.executors.operators.NotEqualOperator;
import com.scriptbasic.executors.operators.PowerOperator;
import com.scriptbasic.syntax.expression.AbstractExpressionAnalyzer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class BasicExpressionAnalyzer
extends AbstractExpressionAnalyzer {
    private static final Integer MAXIMUM_PRIORITY = 6;
    private static final List<Map<String, Class<? extends AbstractBinaryOperator>>> BASIC_OPERATOR_MAPS = new ArrayList<Map<String, Class<? extends AbstractBinaryOperator>>>(MAXIMUM_PRIORITY + 1);

    public BasicExpressionAnalyzer(Context ctx) {
        super(ctx);
    }

    @Override
    protected Integer getMaximumPriority() {
        return MAXIMUM_PRIORITY;
    }

    @Override
    protected Map<String, Class<? extends AbstractBinaryOperator>> getOperatorMap(Integer priority) {
        return BASIC_OPERATOR_MAPS.get(priority - 1);
    }

    static {
        BASIC_OPERATOR_MAPS.add(Map.of(".", JavaObjectFieldAccessOperator.class));
        BASIC_OPERATOR_MAPS.add(Map.of("^", PowerOperator.class));
        BASIC_OPERATOR_MAPS.add(Map.of("*", MultiplyOperator.class, "/", DivideOperator.class, "%", ModuloOperator.class, "div", IntegerDivideOperator.class));
        BASIC_OPERATOR_MAPS.add(Map.of("+", AddOperator.class, "-", MinusOperator.class, "&", AmpersandOperator.class));
        BASIC_OPERATOR_MAPS.add(Map.of("=", EqualsOperator.class, "<", LessThanOperator.class, ">", GreaterThanOperator.class, ">=", GreaterOrEqualOperator.class, "<=", LessOrEqualOperator.class, "<>", NotEqualOperator.class));
        BASIC_OPERATOR_MAPS.add(Map.of("and", LogicalAndOperator.class, "or", LogicalOrOperator.class));
    }
}

