/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.syntax.commands;

import com.scriptbasic.context.Context;
import com.scriptbasic.exceptions.CommandFactoryException;
import com.scriptbasic.interfaces.AnalysisException;
import com.scriptbasic.interfaces.CommandAnalyzer;
import com.scriptbasic.interfaces.CommandFactory;
import com.scriptbasic.log.Logger;
import com.scriptbasic.log.LoggerFactory;
import com.scriptbasic.spi.Command;
import com.scriptbasic.syntax.commands.CommandAnalyzerCall;
import com.scriptbasic.syntax.commands.CommandAnalyzerCase;
import com.scriptbasic.syntax.commands.CommandAnalyzerDSL;
import com.scriptbasic.syntax.commands.CommandAnalyzerElse;
import com.scriptbasic.syntax.commands.CommandAnalyzerElseIf;
import com.scriptbasic.syntax.commands.CommandAnalyzerEnd;
import com.scriptbasic.syntax.commands.CommandAnalyzerEndIf;
import com.scriptbasic.syntax.commands.CommandAnalyzerEndSub;
import com.scriptbasic.syntax.commands.CommandAnalyzerFor;
import com.scriptbasic.syntax.commands.CommandAnalyzerGlobal;
import com.scriptbasic.syntax.commands.CommandAnalyzerIf;
import com.scriptbasic.syntax.commands.CommandAnalyzerLet;
import com.scriptbasic.syntax.commands.CommandAnalyzerLocal;
import com.scriptbasic.syntax.commands.CommandAnalyzerMethod;
import com.scriptbasic.syntax.commands.CommandAnalyzerNext;
import com.scriptbasic.syntax.commands.CommandAnalyzerPrint;
import com.scriptbasic.syntax.commands.CommandAnalyzerReturn;
import com.scriptbasic.syntax.commands.CommandAnalyzerSelect;
import com.scriptbasic.syntax.commands.CommandAnalyzerSub;
import com.scriptbasic.syntax.commands.CommandAnalyzerUse;
import com.scriptbasic.syntax.commands.CommandAnalyzerWend;
import com.scriptbasic.syntax.commands.CommandAnalyzerWhile;
import java.util.List;
import java.util.Map;

public final class BasicCommandFactory
implements CommandFactory {
    private static final Logger LOG = LoggerFactory.getLogger();
    private final Context ctx;
    private final CommandAnalyzerDSL dslAnalyzer;
    private final Map<String, CommandAnalyzer> classMap;
    private final List<CommandAnalyzer> classList;

    public BasicCommandFactory(Context ctx) {
        this.ctx = ctx;
        this.dslAnalyzer = new CommandAnalyzerDSL(ctx);
        this.classMap = Map.ofEntries(Map.entry("while", new CommandAnalyzerWhile(ctx)), Map.entry("wend", new CommandAnalyzerWend(ctx)), Map.entry("if", new CommandAnalyzerIf(ctx)), Map.entry("else", new CommandAnalyzerElse(ctx)), Map.entry("elseif", new CommandAnalyzerElseIf(ctx)), Map.entry("endif", new CommandAnalyzerEndIf(ctx)), Map.entry("use", new CommandAnalyzerUse(ctx)), Map.entry("method", new CommandAnalyzerMethod(ctx)), Map.entry("sub", new CommandAnalyzerSub(ctx)), Map.entry("endsub", new CommandAnalyzerEndSub(ctx)), Map.entry("return", new CommandAnalyzerReturn(ctx)), Map.entry("print", new CommandAnalyzerPrint(ctx)), Map.entry("local", new CommandAnalyzerLocal(ctx)), Map.entry("global", new CommandAnalyzerGlobal(ctx)), Map.entry("call", new CommandAnalyzerCall(ctx)), Map.entry("let", new CommandAnalyzerLet(ctx)), Map.entry("for", new CommandAnalyzerFor(ctx)), Map.entry("next", new CommandAnalyzerNext(ctx)), Map.entry("select", new CommandAnalyzerSelect(ctx)), Map.entry("end", new CommandAnalyzerEnd(ctx)), Map.entry("case", new CommandAnalyzerCase(ctx)), Map.entry("sentence", this.dslAnalyzer));
        this.classList = List.of(new CommandAnalyzerLet(ctx), new CommandAnalyzerCall(ctx), this.dslAnalyzer);
    }

    @Override
    public Command create(String commandKeyword) throws AnalysisException {
        if (commandKeyword == null) {
            return this.create();
        }
        return this.createFromStartingSymbol(commandKeyword);
    }

    private Command create() throws AnalysisException {
        for (CommandAnalyzer commandAnalyzer : this.classList) {
            try {
                LOG.debug("trying to analyze the line using {}", commandAnalyzer.getClass());
                Command command = (Command)commandAnalyzer.analyze();
                if (command != null) {
                    return command;
                }
            }
            catch (AnalysisException e) {
                LOG.debug("Tried but not analyze the line using " + String.valueOf(commandAnalyzer.getClass()), e);
            }
            this.ctx.lexicalAnalyzer.resetLine();
        }
        LOG.debug("None of the analyzers could analyze the line", new Object[0]);
        throw new CommandFactoryException("The line could not be analyzed");
    }

    private Command createFromStartingSymbol(String commandKeyword) throws AnalysisException {
        String lowerCaseCommandKeyword = commandKeyword.toLowerCase();
        LOG.debug("Creating command starting with the keyword '{}'", lowerCaseCommandKeyword);
        if (this.classMap.containsKey(lowerCaseCommandKeyword)) {
            try {
                return (Command)this.classMap.get(lowerCaseCommandKeyword).analyze();
            }
            catch (AnalysisException originalException) {
                try {
                    return this.dslAnalyzer.analyze();
                }
                catch (AnalysisException ignored) {
                    throw originalException;
                }
            }
        }
        return this.dslAnalyzer.analyze();
    }
}

