/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.utility;

import com.scriptbasic.interfaces.BasicRuntimeException;
import com.scriptbasic.interfaces.BasicSyntaxException;
import com.scriptbasic.interfaces.Magic;
import com.scriptbasic.spi.NoAccess;
import com.scriptbasic.utility.CastUtility;
import com.scriptbasic.utility.NoInstance;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Optional;

public final class KlassUtility {
    private static final String SETTER_PREFIX = "set";
    private static final int SETTER_PREFIX_LEN = "set".length();

    private KlassUtility() {
        NoInstance.isPossible();
    }

    public static void setField(Object object, String fieldName, Object valueObject) throws BasicRuntimeException {
        if (object == null) {
            throw new BasicRuntimeException("The field '" + fieldName + "' is not allowed to be write in object undefined ");
        }
        if (object instanceof NoAccess) {
            throw new BasicRuntimeException("The field '" + fieldName + "' is not allowed to be written in object of the type '" + object.getClass().getName());
        }
        Class<?> klass = object.getClass();
        if (Magic.Setter.class.isAssignableFrom(klass)) {
            Magic.Setter magicBean = (Magic.Setter)object;
            magicBean.set(fieldName, valueObject);
        } else {
            try {
                Field field = KlassUtility.getField(klass, fieldName);
                Method setter = KlassUtility.getSetter(field);
                if (setter != null) {
                    setter.invoke(object, valueObject);
                } else {
                    Class<?> fieldClass = field.getType();
                    Object typeConvertedValueObject = CastUtility.cast(valueObject, fieldClass);
                    field.set(object, typeConvertedValueObject);
                }
            }
            catch (Exception e) {
                throw new BasicRuntimeException("Object access of type " + String.valueOf(object.getClass()) + " can not set field '" + fieldName + "'", e);
            }
        }
    }

    public static Object getField(Object object, String fieldName) throws BasicRuntimeException {
        Object result;
        if (object == null) {
            throw new BasicRuntimeException("The field '" + fieldName + "' is not allowed to be read from object undefined.");
        }
        if (object instanceof NoAccess) {
            throw new BasicRuntimeException("The field '" + fieldName + "' is not allowed to be read in object of the type '" + object.getClass().getName());
        }
        Class<?> klass = object.getClass();
        if (Magic.Getter.class.isAssignableFrom(klass)) {
            Magic.Getter magicBean = (Magic.Getter)object;
            return magicBean.get(fieldName);
        }
        try {
            Field field = KlassUtility.getField(klass, fieldName);
            Method getter = KlassUtility.getGetter(field);
            result = getter != null ? getter.invoke(object, new Object[0]) : field.get(object);
        }
        catch (Exception e) {
            throw new BasicRuntimeException("Object access of type " + String.valueOf(object.getClass()) + " can not access field '" + fieldName + "'", e);
        }
        return result;
    }

    public static Class<?> forName(String s) throws ClassNotFoundException {
        StringBuilder className = new StringBuilder(s);
        Class<?> klass = null;
        ClassNotFoundException firstCaughtException = null;
        while (klass == null) {
            try {
                klass = Class.forName(className.toString());
            }
            catch (ClassNotFoundException ex) {
                firstCaughtException = Optional.ofNullable(firstCaughtException).orElse(ex);
                int lastDotPosition = className.lastIndexOf(".");
                if (lastDotPosition == -1) {
                    throw firstCaughtException;
                }
                className.setCharAt(lastDotPosition, '$');
            }
        }
        return klass;
    }

    public static Class<?> forNameEx(String s) throws BasicSyntaxException {
        Class<Comparable<Byte>> klass;
        switch (s) {
            case "byte": {
                klass = Byte.TYPE;
                break;
            }
            case "short": {
                klass = Short.TYPE;
                break;
            }
            case "char": {
                klass = Character.TYPE;
                break;
            }
            case "double": {
                klass = Double.TYPE;
                break;
            }
            case "float": {
                klass = Float.TYPE;
                break;
            }
            case "long": {
                klass = Long.TYPE;
                break;
            }
            case "int": {
                klass = Integer.TYPE;
                break;
            }
            case "boolean": {
                klass = Boolean.TYPE;
                break;
            }
            default: {
                try {
                    klass = KlassUtility.forName(s);
                    break;
                }
                catch (ClassNotFoundException e) {
                    throw new BasicSyntaxException("Can not get class " + s, e);
                }
            }
        }
        return klass;
    }

    private static Method getSetter(Field field) {
        String fieldName = field.getName();
        StringBuilder sb = new StringBuilder(SETTER_PREFIX).append(fieldName);
        sb.setCharAt(SETTER_PREFIX_LEN, Character.toUpperCase(sb.charAt(SETTER_PREFIX_LEN)));
        try {
            return field.getDeclaringClass().getMethod(sb.toString(), field.getType());
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private static Method getGetter(Field field) {
        Method getGetter = KlassUtility.getterPrefixed(field, "get");
        Method isGetter = Boolean.class.isAssignableFrom(field.getType()) || Boolean.TYPE.isAssignableFrom(field.getType()) ? KlassUtility.getterPrefixed(field, "is") : null;
        if (isGetter != null) {
            return isGetter;
        }
        return getGetter;
    }

    private static Method getterPrefixed(Field field, String prefix) {
        String fieldName = field.getName();
        int prefixLength = prefix.length();
        StringBuilder sb = new StringBuilder(prefix).append(fieldName);
        sb.setCharAt(prefixLength, Character.toUpperCase(sb.charAt(prefixLength)));
        try {
            return field.getDeclaringClass().getMethod(sb.toString(), new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private static Field getField(Class<?> klass, String fieldName) throws NoSuchFieldException {
        try {
            return klass.getField(fieldName);
        }
        catch (NoSuchFieldException e) {
            return klass.getDeclaredField(fieldName);
        }
    }
}

