/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.utility.functions;

import com.scriptbasic.api.BasicFunction;
import com.scriptbasic.api.ScriptBasicException;
import com.scriptbasic.classification.Date;
import com.scriptbasic.classification.Utility;
import com.scriptbasic.executors.rightvalues.BasicDateValue;
import com.scriptbasic.interfaces.BasicRuntimeException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;

public class DateFunctions {
    static DateParser dateParser = DateFunctions::isoDateParser;
    static DateFormatter dateFormatter = DateFunctions::isoDateFormatter;
    public static final LocalDate DATE_ZERO = LocalDate.of(1899, 12, 30);

    public static void setDateParser(DateParser parser) {
        dateParser = parser;
    }

    public static DateParser getDateParser() {
        return dateParser;
    }

    public static void setDateFormatter(DateFormatter formatter) {
        dateFormatter = formatter;
    }

    public static DateFormatter getDateFormatter() {
        return dateFormatter;
    }

    @BasicFunction(classification={Date.class, Utility.class})
    public static LocalDate cdate(Object o) throws BasicRuntimeException {
        if (o == null) {
            throw new BasicRuntimeException("Invalid argument NULL");
        }
        if (o instanceof LocalDate) {
            return (LocalDate)o;
        }
        if (o instanceof String) {
            String s = (String)o;
            return dateParser.parseDate(s);
        }
        if (o instanceof Long) {
            Long l = (Long)o;
            return DATE_ZERO.plusDays(l);
        }
        throw new BasicRuntimeException("Conversion to date failed: " + o.toString());
    }

    @BasicFunction(classification={Date.class, Utility.class})
    public static LocalDate date() {
        return LocalDate.now();
    }

    @BasicFunction(classification={Date.class, Utility.class})
    public static Integer year(Object operand) throws ScriptBasicException {
        if (operand == null) {
            return null;
        }
        LocalDate localDate = DateFunctions.cdate(operand);
        return localDate.getYear();
    }

    @BasicFunction(classification={Date.class, Utility.class})
    public static Integer month(Object operand) throws ScriptBasicException {
        if (operand == null) {
            return null;
        }
        LocalDate localDate = DateFunctions.cdate(operand);
        return localDate.getMonthValue();
    }

    @BasicFunction(classification={Date.class, Utility.class})
    public static Integer day(Object operand) throws ScriptBasicException {
        if (operand == null) {
            return null;
        }
        LocalDate localDate = DateFunctions.cdate(operand);
        return localDate.getDayOfMonth();
    }

    @BasicFunction(classification={Date.class, Utility.class})
    public static BasicDateValue dateserial(Integer year, Integer month, Integer dayOfMonth) throws ScriptBasicException {
        if (year < 100 || year > 9999) {
            throw new ScriptBasicException("Year is out of range (100, 9999), value: " + year);
        }
        LocalDate localDate = LocalDate.of((int)year, month, (int)dayOfMonth);
        return new BasicDateValue(localDate);
    }

    @BasicFunction(classification={Date.class, Utility.class})
    public static LocalDate dateadd(String interval, Long number, Object date) throws ScriptBasicException {
        LocalDate dt = DateFunctions.cdate(date);
        switch (interval) {
            case "d": {
                return dt.plusDays(number);
            }
            case "m": {
                return dt.plusMonths(number);
            }
            case "ww": {
                return dt.plusWeeks(number);
            }
            case "yyyy": {
                return dt.plusYears(number);
            }
        }
        throw new ScriptBasicException("Unsupported interval type: " + interval);
    }

    @BasicFunction(classification={Date.class, Utility.class})
    public static long datediff(String interval, LocalDate date1, LocalDate date2) throws ScriptBasicException {
        switch (interval.toLowerCase()) {
            case "d": {
                return date2.toEpochDay() - date1.toEpochDay();
            }
            case "m": {
                return date2.getYear() * 12 + date2.getMonthValue() - (date1.getYear() * 12 + date1.getMonthValue());
            }
            case "yyyy": {
                return date2.getYear() - date1.getYear();
            }
        }
        throw new ScriptBasicException("Unsupported interval type: " + interval);
    }

    public static LocalDate isoDateParser(String src) throws BasicRuntimeException {
        try {
            return LocalDate.parse(src);
        }
        catch (DateTimeParseException e) {
            throw new BasicRuntimeException("Failed to parse: " + src, e);
        }
    }

    public static String isoDateFormatter(LocalDate localDate) {
        return localDate.format(DateTimeFormatter.ISO_DATE);
    }

    @BasicFunction(classification={Date.class, Utility.class})
    public static boolean isDate(Object o) {
        if (o == null) {
            return false;
        }
        try {
            DateFunctions.cdate(o);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static interface DateParser {
        public LocalDate parseDate(String var1) throws BasicRuntimeException;
    }

    public static interface DateFormatter {
        public String formatDate(LocalDate var1);
    }
}

