/*
 * Decompiled with CFR 0.152.
 */
package com.shift4.exception;

import com.shift4.enums.ErrorCode;
import com.shift4.enums.ErrorType;
import com.shift4.response.ErrorResponse;
import com.shift4.util.Shift4Utils;
import java.util.HashMap;
import java.util.Map;

public class Shift4Exception
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private final String type;
    private final String code;
    private final String issuerDeclineCode;
    private final String chargeId;
    private final String creditId;
    private final String blacklistRuleId;
    private final String alertRuleId;
    private final String alertId;
    private final Map<String, Object> other;

    public Shift4Exception(String message, String type, String code, String issuerDeclineCode, String chargeId, String creditId, String blacklistRuleId, String alertRuleId, String alertId, Map<String, Object> other) {
        super(message);
        this.type = type;
        this.code = code;
        this.issuerDeclineCode = issuerDeclineCode;
        this.chargeId = chargeId;
        this.creditId = creditId;
        this.blacklistRuleId = blacklistRuleId;
        this.alertRuleId = alertRuleId;
        this.alertId = alertId;
        this.other = new HashMap<String, Object>(other);
    }

    public Shift4Exception(ErrorResponse error) {
        this(error.getMessage(), error.getTypeAsString(), error.getCodeAsString(), error.getIssuerDeclineCode(), error.getChargeId(), error.getCreditId(), error.getBlacklistRuleId(), error.getAlertRuleId(), error.getAlertId(), error.getOther());
    }

    public ErrorType getType() {
        return ErrorType.fromValue(this.type);
    }

    public String getTypeAsString() {
        return this.type;
    }

    public ErrorCode getCode() {
        return ErrorCode.fromValue(this.code);
    }

    public String getCodeAsString() {
        return this.code;
    }

    public String getIssuerDeclineCode() {
        return this.issuerDeclineCode;
    }

    public String getChargeId() {
        return this.chargeId;
    }

    public String getCreditId() {
        return this.creditId;
    }

    public String getBlacklistRuleId() {
        return this.blacklistRuleId;
    }

    public String getAlertRuleId() {
        return this.alertRuleId;
    }

    public String getAlertId() {
        return this.alertId;
    }

    public String get(String name) {
        return Shift4Utils.toStringNullSafe(this.other.get(name));
    }
}

