/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.api.common.log;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.stackify.api.AppIdentity;
import com.stackify.api.EnvironmentDetail;
import com.stackify.api.LogMsg;
import com.stackify.api.LogMsgGroup;
import com.stackify.api.common.AppIdentityService;
import com.stackify.api.common.http.HttpException;
import com.stackify.api.common.lang.EvictingQueue;
import com.stackify.api.common.log.LogSender;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;

public class LogCollector {
    private static final int MAX_BATCH = 100;
    private final String logger;
    private final EnvironmentDetail envDetail;
    private final AppIdentityService appIdentityService;
    private final Queue<LogMsg> queue = Queues.synchronizedQueue(new EvictingQueue(10000));

    public LogCollector(String logger, EnvironmentDetail envDetail, AppIdentityService appIdentityService) {
        Preconditions.checkNotNull((Object)logger);
        Preconditions.checkNotNull((Object)envDetail);
        Preconditions.checkNotNull((Object)appIdentityService);
        this.logger = logger;
        this.envDetail = envDetail;
        this.appIdentityService = appIdentityService;
    }

    public void addLogMsg(LogMsg logMsg) {
        Preconditions.checkNotNull((Object)logMsg);
        this.queue.offer(logMsg);
    }

    public int flush(LogSender sender) throws IOException, HttpException {
        int numSent;
        int maxToSend = this.queue.size();
        if (0 < maxToSend) {
            int batchSize;
            Optional<AppIdentity> appIdentity = this.appIdentityService.getAppIdentity();
            for (numSent = 0; numSent < maxToSend; numSent += batchSize) {
                batchSize = Math.min(maxToSend - numSent, 100);
                ArrayList batch = Lists.newArrayListWithCapacity((int)batchSize);
                for (int i = 0; i < batchSize; ++i) {
                    batch.add(this.queue.remove());
                }
                LogMsgGroup group = this.createLogMessageGroup(batch, this.logger, this.envDetail, appIdentity);
                int httpStatus = sender.send(group);
                if (httpStatus == 200) continue;
                throw new HttpException(httpStatus);
            }
        }
        return numSent;
    }

    private LogMsgGroup createLogMessageGroup(List<LogMsg> batch, String logger, EnvironmentDetail envDetail, Optional<AppIdentity> appIdentity) {
        LogMsgGroup.Builder groupBuilder = LogMsgGroup.newBuilder();
        groupBuilder.platform("java").logger(logger).serverName(envDetail.getDeviceName()).env(envDetail.getConfiguredEnvironmentName()).appName(envDetail.getConfiguredAppName()).appLoc(envDetail.getAppLocation());
        if (appIdentity.isPresent()) {
            groupBuilder.cdId(((AppIdentity)appIdentity.get()).getDeviceId()).cdAppId(((AppIdentity)appIdentity.get()).getDeviceAppId()).appNameId(((AppIdentity)appIdentity.get()).getAppNameId()).appEnvId(((AppIdentity)appIdentity.get()).getAppEnvId()).envId(((AppIdentity)appIdentity.get()).getEnvId()).env(((AppIdentity)appIdentity.get()).getEnv());
            if (((AppIdentity)appIdentity.get()).getAppName() != null && 0 < ((AppIdentity)appIdentity.get()).getAppName().length()) {
                groupBuilder.appName(((AppIdentity)appIdentity.get()).getAppName());
            }
        }
        groupBuilder.msgs(batch);
        return groupBuilder.build();
    }
}

