/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.api.common.log;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Optional;
import com.stackify.api.WebRequestDetail;
import org.slf4j.helpers.BasicMDCAdapter;
import org.slf4j.spi.MDCAdapter;

public class ServletLogContext {
    private static final String TRANSACTION_ID = "STACKIFY_TRANSACTIONID";
    private static final String USER = "STACKIFY_USER";
    private static final String WEB_REQUEST = "STACKIFY_WEBREQUEST";
    private static final ObjectMapper JSON = new ObjectMapper();
    private static final MDCAdapter MDC = new BasicMDCAdapter();

    public static Optional<String> getTransactionId() {
        String value = MDC.get(TRANSACTION_ID);
        if (value != null && 0 < value.length()) {
            return Optional.of((Object)value);
        }
        return Optional.absent();
    }

    public static void putTransactionId(String transactionId) {
        if (transactionId != null && 0 < transactionId.length()) {
            MDC.put(TRANSACTION_ID, transactionId);
        }
    }

    public static Optional<String> getUser() {
        String value = MDC.get(USER);
        if (value != null && 0 < value.length()) {
            return Optional.of((Object)value);
        }
        return Optional.absent();
    }

    public static void putUser(String user) {
        if (user != null && 0 < user.length()) {
            MDC.put(USER, user);
        }
    }

    public static Optional<WebRequestDetail> getWebRequest() {
        String value = MDC.get(WEB_REQUEST);
        if (value != null && 0 < value.length()) {
            try {
                WebRequestDetail webRequest = (WebRequestDetail)JSON.readValue(value, WebRequestDetail.class);
                return Optional.fromNullable((Object)webRequest);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return Optional.absent();
    }

    public static void putWebRequest(WebRequestDetail webRequest) {
        if (webRequest != null) {
            try {
                String value = JSON.writeValueAsString((Object)webRequest);
                MDC.put(WEB_REQUEST, value);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void clear() {
        MDC.clear();
    }
}

