/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */


package com.stackone.stackone_client_java.models.components;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;
/**
 * Country - The country code
 */

public class Country {

    /**
     * The ISO3166-1 Alpha2 Code of the Country
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("value")
    private JsonNullable<? extends NationalIdentityNumberApiModelCountryValue> value;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("source_value")
    private JsonNullable<? extends NationalIdentityNumberApiModelCountrySourceValue> sourceValue;

    @JsonCreator
    public Country(
            @JsonProperty("value") JsonNullable<? extends NationalIdentityNumberApiModelCountryValue> value,
            @JsonProperty("source_value") JsonNullable<? extends NationalIdentityNumberApiModelCountrySourceValue> sourceValue) {
        Utils.checkNotNull(value, "value");
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.value = value;
        this.sourceValue = sourceValue;
    }
    
    public Country() {
        this(JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * The ISO3166-1 Alpha2 Code of the Country
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<NationalIdentityNumberApiModelCountryValue> value() {
        return (JsonNullable<NationalIdentityNumberApiModelCountryValue>) value;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<NationalIdentityNumberApiModelCountrySourceValue> sourceValue() {
        return (JsonNullable<NationalIdentityNumberApiModelCountrySourceValue>) sourceValue;
    }

    public final static Builder builder() {
        return new Builder();
    }

    /**
     * The ISO3166-1 Alpha2 Code of the Country
     */
    public Country withValue(NationalIdentityNumberApiModelCountryValue value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of(value);
        return this;
    }

    /**
     * The ISO3166-1 Alpha2 Code of the Country
     */
    public Country withValue(JsonNullable<? extends NationalIdentityNumberApiModelCountryValue> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    public Country withSourceValue(NationalIdentityNumberApiModelCountrySourceValue sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = JsonNullable.of(sourceValue);
        return this;
    }

    public Country withSourceValue(JsonNullable<? extends NationalIdentityNumberApiModelCountrySourceValue> sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = sourceValue;
        return this;
    }
    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Country other = (Country) o;
        return 
            Objects.deepEquals(this.value, other.value) &&
            Objects.deepEquals(this.sourceValue, other.sourceValue);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            value,
            sourceValue);
    }
    
    @Override
    public String toString() {
        return Utils.toString(Country.class,
                "value", value,
                "sourceValue", sourceValue);
    }
    
    public final static class Builder {
 
        private JsonNullable<? extends NationalIdentityNumberApiModelCountryValue> value = JsonNullable.undefined();
 
        private JsonNullable<? extends NationalIdentityNumberApiModelCountrySourceValue> sourceValue = JsonNullable.undefined();  
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * The ISO3166-1 Alpha2 Code of the Country
         */
        public Builder value(NationalIdentityNumberApiModelCountryValue value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of(value);
            return this;
        }

        /**
         * The ISO3166-1 Alpha2 Code of the Country
         */
        public Builder value(JsonNullable<? extends NationalIdentityNumberApiModelCountryValue> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }

        public Builder sourceValue(NationalIdentityNumberApiModelCountrySourceValue sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = JsonNullable.of(sourceValue);
            return this;
        }

        public Builder sourceValue(JsonNullable<? extends NationalIdentityNumberApiModelCountrySourceValue> sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = sourceValue;
            return this;
        }
        
        public Country build() {
            return new Country(
                value,
                sourceValue);
        }
    }
}

