/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */


package com.stackone.stackone_client_java.models.components;
import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;


/**
 * <p>Wrapper class for an "open" enum. "Open" enums are those that are expected
 * to evolve (particularly with the addition of enum members over time). If an
 * open enum is used then the appearance of unexpected enum values (say in a 
 * response from an updated an API) will not bring about a runtime error thus 
 * ensuring that non-updated client versions can continue to work without error.
 *
 * <p>Note that instances are immutable and are singletons (an internal thread-safe
 * cache is maintained to ensure that). As a consequence instances created with the 
 * same value will satisfy reference equality (via {@code ==}).
 * 
 * <p>This class is intended to emulate an enum (in terms of common usage and with 
 * reference equality) but with the ability to carry unknown values. Unfortunately
 * Java does not permit the use of an instance in a switch expression but you can 
 * use the {@code asEnum()} method (after dealing with the `Optional` appropriately).
 *
 */
/**
 * IamPermissionValue - The type of the permission, e.g. read, read_write, delete, etc.
 */
@JsonDeserialize(using = IamPermissionValue._Deserializer.class)
@JsonSerialize(using = IamPermissionValue._Serializer.class)
public class IamPermissionValue {

    public static final IamPermissionValue READ = new IamPermissionValue("read");
    public static final IamPermissionValue READ_WRITE = new IamPermissionValue("read_write");
    public static final IamPermissionValue APPROVE = new IamPermissionValue("approve");
    public static final IamPermissionValue DELETE = new IamPermissionValue("delete");
    public static final IamPermissionValue USE = new IamPermissionValue("use");
    public static final IamPermissionValue EXPORT = new IamPermissionValue("export");
    public static final IamPermissionValue UNMAPPED_VALUE = new IamPermissionValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, IamPermissionValue> values = createValuesMap();
    private static final Map<String, IamPermissionValueEnum> enums = createEnumsMap();

    private final String value;

    private IamPermissionValue(String value) {
        this.value = value;
    }

    /**
     * Returns a IamPermissionValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as IamPermissionValue
     */ 
    public static IamPermissionValue of(String value) {
        synchronized (IamPermissionValue.class) {
            return values.computeIfAbsent(value, v -> new IamPermissionValue(v));
        }
    }

    public String value() {
        return value;
    }

    public Optional<IamPermissionValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        IamPermissionValue other = (IamPermissionValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "IamPermissionValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static IamPermissionValue[] values() {
        synchronized (IamPermissionValue.class) {
            return values.values().toArray(new IamPermissionValue[] {});
        }
    }

    private static final Map<String, IamPermissionValue> createValuesMap() {
        Map<String, IamPermissionValue> map = new LinkedHashMap<>();
        map.put("read", READ);
        map.put("read_write", READ_WRITE);
        map.put("approve", APPROVE);
        map.put("delete", DELETE);
        map.put("use", USE);
        map.put("export", EXPORT);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, IamPermissionValueEnum> createEnumsMap() {
        Map<String, IamPermissionValueEnum> map = new HashMap<>();
        map.put("read", IamPermissionValueEnum.READ);
        map.put("read_write", IamPermissionValueEnum.READ_WRITE);
        map.put("approve", IamPermissionValueEnum.APPROVE);
        map.put("delete", IamPermissionValueEnum.DELETE);
        map.put("use", IamPermissionValueEnum.USE);
        map.put("export", IamPermissionValueEnum.EXPORT);
        map.put("unmapped_value", IamPermissionValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    @SuppressWarnings("serial")
    public static final class _Serializer extends StdSerializer<IamPermissionValue> {

        protected _Serializer() {
            super(IamPermissionValue.class);
        }

        @Override
        public void serialize(IamPermissionValue value, JsonGenerator g, SerializerProvider provider)
                throws IOException, JsonProcessingException {
            g.writeObject(value.value);
        }
    }

    @SuppressWarnings("serial")
    public static final class _Deserializer extends StdDeserializer<IamPermissionValue> {

        protected _Deserializer() {
            super(IamPermissionValue.class);
        }

        @Override
        public IamPermissionValue deserialize(JsonParser p, DeserializationContext ctxt)
                throws IOException, JacksonException {
            String v = p.readValueAs(new TypeReference<String>() {});
            // use the factory method to ensure we get singletons
            return IamPermissionValue.of(v);
        }
    }
    
    public enum IamPermissionValueEnum {

        READ("read"),
        READ_WRITE("read_write"),
        APPROVE("approve"),
        DELETE("delete"),
        USE("use"),
        EXPORT("export"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private IamPermissionValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}
