/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */


package com.stackone.stackone_client_java.models.components;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

public class IamUser {

    /**
     * Unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("id")
    private JsonNullable<String> id;

    /**
     * Provider's unique identifier
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("remote_id")
    private JsonNullable<String> remoteId;

    /**
     * Custom Unified Fields configured in your StackOne project
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("unified_custom_fields")
    private JsonNullable<? extends Map<String, Object>> unifiedCustomFields;

    /**
     * Primary email address of the user. This is generally a work email address.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("primary_email_address")
    private JsonNullable<String> primaryEmailAddress;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("first_name")
    private JsonNullable<String> firstName;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("last_name")
    private JsonNullable<String> lastName;

    /**
     * User's name which (can be a full name or display name)
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("name")
    private JsonNullable<String> name;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("username")
    private JsonNullable<String> username;

    /**
     * Indicates if the user is a bot or service user
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("is_bot_user")
    private JsonNullable<? extends IsBotUser> isBotUser;

    /**
     * List of roles the user is assigned to
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("roles")
    private JsonNullable<? extends List<IamRole>> roles;

    /**
     * List of groups the user is assigned to
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("groups")
    private JsonNullable<? extends List<IamGroup>> groups;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("status")
    private JsonNullable<? extends IamUserStatus> status;

    /**
     * The date this user was last active
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("last_active_at")
    private JsonNullable<OffsetDateTime> lastActiveAt;

    /**
     * The date this user last logged in
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("last_login_at")
    private JsonNullable<OffsetDateTime> lastLoginAt;

    /**
     * The date the user was created
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("created_at")
    private JsonNullable<OffsetDateTime> createdAt;

    /**
     * The date the user was created
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("updated_at")
    private JsonNullable<OffsetDateTime> updatedAt;

    /**
     * The list of Multi-Factor Authentication (MFA) types enabled for the user.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("multi_factor_enabled")
    private JsonNullable<? extends List<IamMfaTypeEnum>> multiFactorEnabled;

    /**
     * The user's avatar data. This generally contains a URL within this property's 'contents' array.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("avatar")
    private JsonNullable<? extends IamUserAvatar> avatar;

    @JsonCreator
    public IamUser(
            @JsonProperty("id") JsonNullable<String> id,
            @JsonProperty("remote_id") JsonNullable<String> remoteId,
            @JsonProperty("unified_custom_fields") JsonNullable<? extends Map<String, Object>> unifiedCustomFields,
            @JsonProperty("primary_email_address") JsonNullable<String> primaryEmailAddress,
            @JsonProperty("first_name") JsonNullable<String> firstName,
            @JsonProperty("last_name") JsonNullable<String> lastName,
            @JsonProperty("name") JsonNullable<String> name,
            @JsonProperty("username") JsonNullable<String> username,
            @JsonProperty("is_bot_user") JsonNullable<? extends IsBotUser> isBotUser,
            @JsonProperty("roles") JsonNullable<? extends List<IamRole>> roles,
            @JsonProperty("groups") JsonNullable<? extends List<IamGroup>> groups,
            @JsonProperty("status") JsonNullable<? extends IamUserStatus> status,
            @JsonProperty("last_active_at") JsonNullable<OffsetDateTime> lastActiveAt,
            @JsonProperty("last_login_at") JsonNullable<OffsetDateTime> lastLoginAt,
            @JsonProperty("created_at") JsonNullable<OffsetDateTime> createdAt,
            @JsonProperty("updated_at") JsonNullable<OffsetDateTime> updatedAt,
            @JsonProperty("multi_factor_enabled") JsonNullable<? extends List<IamMfaTypeEnum>> multiFactorEnabled,
            @JsonProperty("avatar") JsonNullable<? extends IamUserAvatar> avatar) {
        Utils.checkNotNull(id, "id");
        Utils.checkNotNull(remoteId, "remoteId");
        Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
        Utils.checkNotNull(primaryEmailAddress, "primaryEmailAddress");
        Utils.checkNotNull(firstName, "firstName");
        Utils.checkNotNull(lastName, "lastName");
        Utils.checkNotNull(name, "name");
        Utils.checkNotNull(username, "username");
        Utils.checkNotNull(isBotUser, "isBotUser");
        Utils.checkNotNull(roles, "roles");
        Utils.checkNotNull(groups, "groups");
        Utils.checkNotNull(status, "status");
        Utils.checkNotNull(lastActiveAt, "lastActiveAt");
        Utils.checkNotNull(lastLoginAt, "lastLoginAt");
        Utils.checkNotNull(createdAt, "createdAt");
        Utils.checkNotNull(updatedAt, "updatedAt");
        Utils.checkNotNull(multiFactorEnabled, "multiFactorEnabled");
        Utils.checkNotNull(avatar, "avatar");
        this.id = id;
        this.remoteId = remoteId;
        this.unifiedCustomFields = unifiedCustomFields;
        this.primaryEmailAddress = primaryEmailAddress;
        this.firstName = firstName;
        this.lastName = lastName;
        this.name = name;
        this.username = username;
        this.isBotUser = isBotUser;
        this.roles = roles;
        this.groups = groups;
        this.status = status;
        this.lastActiveAt = lastActiveAt;
        this.lastLoginAt = lastLoginAt;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.multiFactorEnabled = multiFactorEnabled;
        this.avatar = avatar;
    }
    
    public IamUser() {
        this(JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * Unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> id() {
        return id;
    }

    /**
     * Provider's unique identifier
     */
    @JsonIgnore
    public JsonNullable<String> remoteId() {
        return remoteId;
    }

    /**
     * Custom Unified Fields configured in your StackOne project
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<Map<String, Object>> unifiedCustomFields() {
        return (JsonNullable<Map<String, Object>>) unifiedCustomFields;
    }

    /**
     * Primary email address of the user. This is generally a work email address.
     */
    @JsonIgnore
    public JsonNullable<String> primaryEmailAddress() {
        return primaryEmailAddress;
    }

    @JsonIgnore
    public JsonNullable<String> firstName() {
        return firstName;
    }

    @JsonIgnore
    public JsonNullable<String> lastName() {
        return lastName;
    }

    /**
     * User's name which (can be a full name or display name)
     */
    @JsonIgnore
    public JsonNullable<String> name() {
        return name;
    }

    @JsonIgnore
    public JsonNullable<String> username() {
        return username;
    }

    /**
     * Indicates if the user is a bot or service user
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<IsBotUser> isBotUser() {
        return (JsonNullable<IsBotUser>) isBotUser;
    }

    /**
     * List of roles the user is assigned to
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<IamRole>> roles() {
        return (JsonNullable<List<IamRole>>) roles;
    }

    /**
     * List of groups the user is assigned to
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<IamGroup>> groups() {
        return (JsonNullable<List<IamGroup>>) groups;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<IamUserStatus> status() {
        return (JsonNullable<IamUserStatus>) status;
    }

    /**
     * The date this user was last active
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> lastActiveAt() {
        return lastActiveAt;
    }

    /**
     * The date this user last logged in
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> lastLoginAt() {
        return lastLoginAt;
    }

    /**
     * The date the user was created
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> createdAt() {
        return createdAt;
    }

    /**
     * The date the user was created
     */
    @JsonIgnore
    public JsonNullable<OffsetDateTime> updatedAt() {
        return updatedAt;
    }

    /**
     * The list of Multi-Factor Authentication (MFA) types enabled for the user.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<IamMfaTypeEnum>> multiFactorEnabled() {
        return (JsonNullable<List<IamMfaTypeEnum>>) multiFactorEnabled;
    }

    /**
     * The user's avatar data. This generally contains a URL within this property's 'contents' array.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<IamUserAvatar> avatar() {
        return (JsonNullable<IamUserAvatar>) avatar;
    }

    public final static Builder builder() {
        return new Builder();
    }

    /**
     * Unique identifier
     */
    public IamUser withId(String id) {
        Utils.checkNotNull(id, "id");
        this.id = JsonNullable.of(id);
        return this;
    }

    /**
     * Unique identifier
     */
    public IamUser withId(JsonNullable<String> id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public IamUser withRemoteId(String remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = JsonNullable.of(remoteId);
        return this;
    }

    /**
     * Provider's unique identifier
     */
    public IamUser withRemoteId(JsonNullable<String> remoteId) {
        Utils.checkNotNull(remoteId, "remoteId");
        this.remoteId = remoteId;
        return this;
    }

    /**
     * Custom Unified Fields configured in your StackOne project
     */
    public IamUser withUnifiedCustomFields(Map<String, Object> unifiedCustomFields) {
        Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
        this.unifiedCustomFields = JsonNullable.of(unifiedCustomFields);
        return this;
    }

    /**
     * Custom Unified Fields configured in your StackOne project
     */
    public IamUser withUnifiedCustomFields(JsonNullable<? extends Map<String, Object>> unifiedCustomFields) {
        Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
        this.unifiedCustomFields = unifiedCustomFields;
        return this;
    }

    /**
     * Primary email address of the user. This is generally a work email address.
     */
    public IamUser withPrimaryEmailAddress(String primaryEmailAddress) {
        Utils.checkNotNull(primaryEmailAddress, "primaryEmailAddress");
        this.primaryEmailAddress = JsonNullable.of(primaryEmailAddress);
        return this;
    }

    /**
     * Primary email address of the user. This is generally a work email address.
     */
    public IamUser withPrimaryEmailAddress(JsonNullable<String> primaryEmailAddress) {
        Utils.checkNotNull(primaryEmailAddress, "primaryEmailAddress");
        this.primaryEmailAddress = primaryEmailAddress;
        return this;
    }

    public IamUser withFirstName(String firstName) {
        Utils.checkNotNull(firstName, "firstName");
        this.firstName = JsonNullable.of(firstName);
        return this;
    }

    public IamUser withFirstName(JsonNullable<String> firstName) {
        Utils.checkNotNull(firstName, "firstName");
        this.firstName = firstName;
        return this;
    }

    public IamUser withLastName(String lastName) {
        Utils.checkNotNull(lastName, "lastName");
        this.lastName = JsonNullable.of(lastName);
        return this;
    }

    public IamUser withLastName(JsonNullable<String> lastName) {
        Utils.checkNotNull(lastName, "lastName");
        this.lastName = lastName;
        return this;
    }

    /**
     * User's name which (can be a full name or display name)
     */
    public IamUser withName(String name) {
        Utils.checkNotNull(name, "name");
        this.name = JsonNullable.of(name);
        return this;
    }

    /**
     * User's name which (can be a full name or display name)
     */
    public IamUser withName(JsonNullable<String> name) {
        Utils.checkNotNull(name, "name");
        this.name = name;
        return this;
    }

    public IamUser withUsername(String username) {
        Utils.checkNotNull(username, "username");
        this.username = JsonNullable.of(username);
        return this;
    }

    public IamUser withUsername(JsonNullable<String> username) {
        Utils.checkNotNull(username, "username");
        this.username = username;
        return this;
    }

    /**
     * Indicates if the user is a bot or service user
     */
    public IamUser withIsBotUser(IsBotUser isBotUser) {
        Utils.checkNotNull(isBotUser, "isBotUser");
        this.isBotUser = JsonNullable.of(isBotUser);
        return this;
    }

    /**
     * Indicates if the user is a bot or service user
     */
    public IamUser withIsBotUser(JsonNullable<? extends IsBotUser> isBotUser) {
        Utils.checkNotNull(isBotUser, "isBotUser");
        this.isBotUser = isBotUser;
        return this;
    }

    /**
     * List of roles the user is assigned to
     */
    public IamUser withRoles(List<IamRole> roles) {
        Utils.checkNotNull(roles, "roles");
        this.roles = JsonNullable.of(roles);
        return this;
    }

    /**
     * List of roles the user is assigned to
     */
    public IamUser withRoles(JsonNullable<? extends List<IamRole>> roles) {
        Utils.checkNotNull(roles, "roles");
        this.roles = roles;
        return this;
    }

    /**
     * List of groups the user is assigned to
     */
    public IamUser withGroups(List<IamGroup> groups) {
        Utils.checkNotNull(groups, "groups");
        this.groups = JsonNullable.of(groups);
        return this;
    }

    /**
     * List of groups the user is assigned to
     */
    public IamUser withGroups(JsonNullable<? extends List<IamGroup>> groups) {
        Utils.checkNotNull(groups, "groups");
        this.groups = groups;
        return this;
    }

    public IamUser withStatus(IamUserStatus status) {
        Utils.checkNotNull(status, "status");
        this.status = JsonNullable.of(status);
        return this;
    }

    public IamUser withStatus(JsonNullable<? extends IamUserStatus> status) {
        Utils.checkNotNull(status, "status");
        this.status = status;
        return this;
    }

    /**
     * The date this user was last active
     */
    public IamUser withLastActiveAt(OffsetDateTime lastActiveAt) {
        Utils.checkNotNull(lastActiveAt, "lastActiveAt");
        this.lastActiveAt = JsonNullable.of(lastActiveAt);
        return this;
    }

    /**
     * The date this user was last active
     */
    public IamUser withLastActiveAt(JsonNullable<OffsetDateTime> lastActiveAt) {
        Utils.checkNotNull(lastActiveAt, "lastActiveAt");
        this.lastActiveAt = lastActiveAt;
        return this;
    }

    /**
     * The date this user last logged in
     */
    public IamUser withLastLoginAt(OffsetDateTime lastLoginAt) {
        Utils.checkNotNull(lastLoginAt, "lastLoginAt");
        this.lastLoginAt = JsonNullable.of(lastLoginAt);
        return this;
    }

    /**
     * The date this user last logged in
     */
    public IamUser withLastLoginAt(JsonNullable<OffsetDateTime> lastLoginAt) {
        Utils.checkNotNull(lastLoginAt, "lastLoginAt");
        this.lastLoginAt = lastLoginAt;
        return this;
    }

    /**
     * The date the user was created
     */
    public IamUser withCreatedAt(OffsetDateTime createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = JsonNullable.of(createdAt);
        return this;
    }

    /**
     * The date the user was created
     */
    public IamUser withCreatedAt(JsonNullable<OffsetDateTime> createdAt) {
        Utils.checkNotNull(createdAt, "createdAt");
        this.createdAt = createdAt;
        return this;
    }

    /**
     * The date the user was created
     */
    public IamUser withUpdatedAt(OffsetDateTime updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = JsonNullable.of(updatedAt);
        return this;
    }

    /**
     * The date the user was created
     */
    public IamUser withUpdatedAt(JsonNullable<OffsetDateTime> updatedAt) {
        Utils.checkNotNull(updatedAt, "updatedAt");
        this.updatedAt = updatedAt;
        return this;
    }

    /**
     * The list of Multi-Factor Authentication (MFA) types enabled for the user.
     */
    public IamUser withMultiFactorEnabled(List<IamMfaTypeEnum> multiFactorEnabled) {
        Utils.checkNotNull(multiFactorEnabled, "multiFactorEnabled");
        this.multiFactorEnabled = JsonNullable.of(multiFactorEnabled);
        return this;
    }

    /**
     * The list of Multi-Factor Authentication (MFA) types enabled for the user.
     */
    public IamUser withMultiFactorEnabled(JsonNullable<? extends List<IamMfaTypeEnum>> multiFactorEnabled) {
        Utils.checkNotNull(multiFactorEnabled, "multiFactorEnabled");
        this.multiFactorEnabled = multiFactorEnabled;
        return this;
    }

    /**
     * The user's avatar data. This generally contains a URL within this property's 'contents' array.
     */
    public IamUser withAvatar(IamUserAvatar avatar) {
        Utils.checkNotNull(avatar, "avatar");
        this.avatar = JsonNullable.of(avatar);
        return this;
    }

    /**
     * The user's avatar data. This generally contains a URL within this property's 'contents' array.
     */
    public IamUser withAvatar(JsonNullable<? extends IamUserAvatar> avatar) {
        Utils.checkNotNull(avatar, "avatar");
        this.avatar = avatar;
        return this;
    }
    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        IamUser other = (IamUser) o;
        return 
            Objects.deepEquals(this.id, other.id) &&
            Objects.deepEquals(this.remoteId, other.remoteId) &&
            Objects.deepEquals(this.unifiedCustomFields, other.unifiedCustomFields) &&
            Objects.deepEquals(this.primaryEmailAddress, other.primaryEmailAddress) &&
            Objects.deepEquals(this.firstName, other.firstName) &&
            Objects.deepEquals(this.lastName, other.lastName) &&
            Objects.deepEquals(this.name, other.name) &&
            Objects.deepEquals(this.username, other.username) &&
            Objects.deepEquals(this.isBotUser, other.isBotUser) &&
            Objects.deepEquals(this.roles, other.roles) &&
            Objects.deepEquals(this.groups, other.groups) &&
            Objects.deepEquals(this.status, other.status) &&
            Objects.deepEquals(this.lastActiveAt, other.lastActiveAt) &&
            Objects.deepEquals(this.lastLoginAt, other.lastLoginAt) &&
            Objects.deepEquals(this.createdAt, other.createdAt) &&
            Objects.deepEquals(this.updatedAt, other.updatedAt) &&
            Objects.deepEquals(this.multiFactorEnabled, other.multiFactorEnabled) &&
            Objects.deepEquals(this.avatar, other.avatar);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            id,
            remoteId,
            unifiedCustomFields,
            primaryEmailAddress,
            firstName,
            lastName,
            name,
            username,
            isBotUser,
            roles,
            groups,
            status,
            lastActiveAt,
            lastLoginAt,
            createdAt,
            updatedAt,
            multiFactorEnabled,
            avatar);
    }
    
    @Override
    public String toString() {
        return Utils.toString(IamUser.class,
                "id", id,
                "remoteId", remoteId,
                "unifiedCustomFields", unifiedCustomFields,
                "primaryEmailAddress", primaryEmailAddress,
                "firstName", firstName,
                "lastName", lastName,
                "name", name,
                "username", username,
                "isBotUser", isBotUser,
                "roles", roles,
                "groups", groups,
                "status", status,
                "lastActiveAt", lastActiveAt,
                "lastLoginAt", lastLoginAt,
                "createdAt", createdAt,
                "updatedAt", updatedAt,
                "multiFactorEnabled", multiFactorEnabled,
                "avatar", avatar);
    }
    
    public final static class Builder {
 
        private JsonNullable<String> id = JsonNullable.undefined();
 
        private JsonNullable<String> remoteId = JsonNullable.undefined();
 
        private JsonNullable<? extends Map<String, Object>> unifiedCustomFields = JsonNullable.undefined();
 
        private JsonNullable<String> primaryEmailAddress = JsonNullable.undefined();
 
        private JsonNullable<String> firstName = JsonNullable.undefined();
 
        private JsonNullable<String> lastName = JsonNullable.undefined();
 
        private JsonNullable<String> name = JsonNullable.undefined();
 
        private JsonNullable<String> username = JsonNullable.undefined();
 
        private JsonNullable<? extends IsBotUser> isBotUser = JsonNullable.undefined();
 
        private JsonNullable<? extends List<IamRole>> roles = JsonNullable.undefined();
 
        private JsonNullable<? extends List<IamGroup>> groups = JsonNullable.undefined();
 
        private JsonNullable<? extends IamUserStatus> status = JsonNullable.undefined();
 
        private JsonNullable<OffsetDateTime> lastActiveAt = JsonNullable.undefined();
 
        private JsonNullable<OffsetDateTime> lastLoginAt = JsonNullable.undefined();
 
        private JsonNullable<OffsetDateTime> createdAt = JsonNullable.undefined();
 
        private JsonNullable<OffsetDateTime> updatedAt = JsonNullable.undefined();
 
        private JsonNullable<? extends List<IamMfaTypeEnum>> multiFactorEnabled = JsonNullable.undefined();
 
        private JsonNullable<? extends IamUserAvatar> avatar = JsonNullable.undefined();  
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * Unique identifier
         */
        public Builder id(String id) {
            Utils.checkNotNull(id, "id");
            this.id = JsonNullable.of(id);
            return this;
        }

        /**
         * Unique identifier
         */
        public Builder id(JsonNullable<String> id) {
            Utils.checkNotNull(id, "id");
            this.id = id;
            return this;
        }

        /**
         * Provider's unique identifier
         */
        public Builder remoteId(String remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = JsonNullable.of(remoteId);
            return this;
        }

        /**
         * Provider's unique identifier
         */
        public Builder remoteId(JsonNullable<String> remoteId) {
            Utils.checkNotNull(remoteId, "remoteId");
            this.remoteId = remoteId;
            return this;
        }

        /**
         * Custom Unified Fields configured in your StackOne project
         */
        public Builder unifiedCustomFields(Map<String, Object> unifiedCustomFields) {
            Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
            this.unifiedCustomFields = JsonNullable.of(unifiedCustomFields);
            return this;
        }

        /**
         * Custom Unified Fields configured in your StackOne project
         */
        public Builder unifiedCustomFields(JsonNullable<? extends Map<String, Object>> unifiedCustomFields) {
            Utils.checkNotNull(unifiedCustomFields, "unifiedCustomFields");
            this.unifiedCustomFields = unifiedCustomFields;
            return this;
        }

        /**
         * Primary email address of the user. This is generally a work email address.
         */
        public Builder primaryEmailAddress(String primaryEmailAddress) {
            Utils.checkNotNull(primaryEmailAddress, "primaryEmailAddress");
            this.primaryEmailAddress = JsonNullable.of(primaryEmailAddress);
            return this;
        }

        /**
         * Primary email address of the user. This is generally a work email address.
         */
        public Builder primaryEmailAddress(JsonNullable<String> primaryEmailAddress) {
            Utils.checkNotNull(primaryEmailAddress, "primaryEmailAddress");
            this.primaryEmailAddress = primaryEmailAddress;
            return this;
        }

        public Builder firstName(String firstName) {
            Utils.checkNotNull(firstName, "firstName");
            this.firstName = JsonNullable.of(firstName);
            return this;
        }

        public Builder firstName(JsonNullable<String> firstName) {
            Utils.checkNotNull(firstName, "firstName");
            this.firstName = firstName;
            return this;
        }

        public Builder lastName(String lastName) {
            Utils.checkNotNull(lastName, "lastName");
            this.lastName = JsonNullable.of(lastName);
            return this;
        }

        public Builder lastName(JsonNullable<String> lastName) {
            Utils.checkNotNull(lastName, "lastName");
            this.lastName = lastName;
            return this;
        }

        /**
         * User's name which (can be a full name or display name)
         */
        public Builder name(String name) {
            Utils.checkNotNull(name, "name");
            this.name = JsonNullable.of(name);
            return this;
        }

        /**
         * User's name which (can be a full name or display name)
         */
        public Builder name(JsonNullable<String> name) {
            Utils.checkNotNull(name, "name");
            this.name = name;
            return this;
        }

        public Builder username(String username) {
            Utils.checkNotNull(username, "username");
            this.username = JsonNullable.of(username);
            return this;
        }

        public Builder username(JsonNullable<String> username) {
            Utils.checkNotNull(username, "username");
            this.username = username;
            return this;
        }

        /**
         * Indicates if the user is a bot or service user
         */
        public Builder isBotUser(IsBotUser isBotUser) {
            Utils.checkNotNull(isBotUser, "isBotUser");
            this.isBotUser = JsonNullable.of(isBotUser);
            return this;
        }

        /**
         * Indicates if the user is a bot or service user
         */
        public Builder isBotUser(JsonNullable<? extends IsBotUser> isBotUser) {
            Utils.checkNotNull(isBotUser, "isBotUser");
            this.isBotUser = isBotUser;
            return this;
        }

        /**
         * List of roles the user is assigned to
         */
        public Builder roles(List<IamRole> roles) {
            Utils.checkNotNull(roles, "roles");
            this.roles = JsonNullable.of(roles);
            return this;
        }

        /**
         * List of roles the user is assigned to
         */
        public Builder roles(JsonNullable<? extends List<IamRole>> roles) {
            Utils.checkNotNull(roles, "roles");
            this.roles = roles;
            return this;
        }

        /**
         * List of groups the user is assigned to
         */
        public Builder groups(List<IamGroup> groups) {
            Utils.checkNotNull(groups, "groups");
            this.groups = JsonNullable.of(groups);
            return this;
        }

        /**
         * List of groups the user is assigned to
         */
        public Builder groups(JsonNullable<? extends List<IamGroup>> groups) {
            Utils.checkNotNull(groups, "groups");
            this.groups = groups;
            return this;
        }

        public Builder status(IamUserStatus status) {
            Utils.checkNotNull(status, "status");
            this.status = JsonNullable.of(status);
            return this;
        }

        public Builder status(JsonNullable<? extends IamUserStatus> status) {
            Utils.checkNotNull(status, "status");
            this.status = status;
            return this;
        }

        /**
         * The date this user was last active
         */
        public Builder lastActiveAt(OffsetDateTime lastActiveAt) {
            Utils.checkNotNull(lastActiveAt, "lastActiveAt");
            this.lastActiveAt = JsonNullable.of(lastActiveAt);
            return this;
        }

        /**
         * The date this user was last active
         */
        public Builder lastActiveAt(JsonNullable<OffsetDateTime> lastActiveAt) {
            Utils.checkNotNull(lastActiveAt, "lastActiveAt");
            this.lastActiveAt = lastActiveAt;
            return this;
        }

        /**
         * The date this user last logged in
         */
        public Builder lastLoginAt(OffsetDateTime lastLoginAt) {
            Utils.checkNotNull(lastLoginAt, "lastLoginAt");
            this.lastLoginAt = JsonNullable.of(lastLoginAt);
            return this;
        }

        /**
         * The date this user last logged in
         */
        public Builder lastLoginAt(JsonNullable<OffsetDateTime> lastLoginAt) {
            Utils.checkNotNull(lastLoginAt, "lastLoginAt");
            this.lastLoginAt = lastLoginAt;
            return this;
        }

        /**
         * The date the user was created
         */
        public Builder createdAt(OffsetDateTime createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = JsonNullable.of(createdAt);
            return this;
        }

        /**
         * The date the user was created
         */
        public Builder createdAt(JsonNullable<OffsetDateTime> createdAt) {
            Utils.checkNotNull(createdAt, "createdAt");
            this.createdAt = createdAt;
            return this;
        }

        /**
         * The date the user was created
         */
        public Builder updatedAt(OffsetDateTime updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = JsonNullable.of(updatedAt);
            return this;
        }

        /**
         * The date the user was created
         */
        public Builder updatedAt(JsonNullable<OffsetDateTime> updatedAt) {
            Utils.checkNotNull(updatedAt, "updatedAt");
            this.updatedAt = updatedAt;
            return this;
        }

        /**
         * The list of Multi-Factor Authentication (MFA) types enabled for the user.
         */
        public Builder multiFactorEnabled(List<IamMfaTypeEnum> multiFactorEnabled) {
            Utils.checkNotNull(multiFactorEnabled, "multiFactorEnabled");
            this.multiFactorEnabled = JsonNullable.of(multiFactorEnabled);
            return this;
        }

        /**
         * The list of Multi-Factor Authentication (MFA) types enabled for the user.
         */
        public Builder multiFactorEnabled(JsonNullable<? extends List<IamMfaTypeEnum>> multiFactorEnabled) {
            Utils.checkNotNull(multiFactorEnabled, "multiFactorEnabled");
            this.multiFactorEnabled = multiFactorEnabled;
            return this;
        }

        /**
         * The user's avatar data. This generally contains a URL within this property's 'contents' array.
         */
        public Builder avatar(IamUserAvatar avatar) {
            Utils.checkNotNull(avatar, "avatar");
            this.avatar = JsonNullable.of(avatar);
            return this;
        }

        /**
         * The user's avatar data. This generally contains a URL within this property's 'contents' array.
         */
        public Builder avatar(JsonNullable<? extends IamUserAvatar> avatar) {
            Utils.checkNotNull(avatar, "avatar");
            this.avatar = avatar;
            return this;
        }
        
        public IamUser build() {
            return new IamUser(
                id,
                remoteId,
                unifiedCustomFields,
                primaryEmailAddress,
                firstName,
                lastName,
                name,
                username,
                isBotUser,
                roles,
                groups,
                status,
                lastActiveAt,
                lastLoginAt,
                createdAt,
                updatedAt,
                multiFactorEnabled,
                avatar);
        }
    }
}

