/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */


package com.stackone.stackone_client_java.models.components;
import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;


/**
 * <p>Wrapper class for an "open" enum. "Open" enums are those that are expected
 * to evolve (particularly with the addition of enum members over time). If an
 * open enum is used then the appearance of unexpected enum values (say in a 
 * response from an updated an API) will not bring about a runtime error thus 
 * ensuring that non-updated client versions can continue to work without error.
 *
 * <p>Note that instances are immutable and are singletons (an internal thread-safe
 * cache is maintained to ensure that). As a consequence instances created with the 
 * same value will satisfy reference equality (via {@code ==}).
 * 
 * <p>This class is intended to emulate an enum (in terms of common usage and with 
 * reference equality) but with the ability to carry unknown values. Unfortunately
 * Java does not permit the use of an instance in a switch expression but you can 
 * use the {@code asEnum()} method (after dealing with the `Optional` appropriately).
 *
 */
/**
 * JobPostingContentSectionValue - The type of the description.
 */
@JsonDeserialize(using = JobPostingContentSectionValue._Deserializer.class)
@JsonSerialize(using = JobPostingContentSectionValue._Serializer.class)
public class JobPostingContentSectionValue {

    public static final JobPostingContentSectionValue RESPONSIBILITIES = new JobPostingContentSectionValue("responsibilities");
    public static final JobPostingContentSectionValue SKILLS = new JobPostingContentSectionValue("skills");
    public static final JobPostingContentSectionValue BENEFITS = new JobPostingContentSectionValue("benefits");
    public static final JobPostingContentSectionValue COMPANY_OVERVIEW = new JobPostingContentSectionValue("company_overview");
    public static final JobPostingContentSectionValue DESCRIPTION = new JobPostingContentSectionValue("description");
    public static final JobPostingContentSectionValue OTHER = new JobPostingContentSectionValue("other");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, JobPostingContentSectionValue> values = createValuesMap();
    private static final Map<String, JobPostingContentSectionValueEnum> enums = createEnumsMap();

    private final String value;

    private JobPostingContentSectionValue(String value) {
        this.value = value;
    }

    /**
     * Returns a JobPostingContentSectionValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as JobPostingContentSectionValue
     */ 
    public static JobPostingContentSectionValue of(String value) {
        synchronized (JobPostingContentSectionValue.class) {
            return values.computeIfAbsent(value, v -> new JobPostingContentSectionValue(v));
        }
    }

    public String value() {
        return value;
    }

    public Optional<JobPostingContentSectionValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        JobPostingContentSectionValue other = (JobPostingContentSectionValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "JobPostingContentSectionValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static JobPostingContentSectionValue[] values() {
        synchronized (JobPostingContentSectionValue.class) {
            return values.values().toArray(new JobPostingContentSectionValue[] {});
        }
    }

    private static final Map<String, JobPostingContentSectionValue> createValuesMap() {
        Map<String, JobPostingContentSectionValue> map = new LinkedHashMap<>();
        map.put("responsibilities", RESPONSIBILITIES);
        map.put("skills", SKILLS);
        map.put("benefits", BENEFITS);
        map.put("company_overview", COMPANY_OVERVIEW);
        map.put("description", DESCRIPTION);
        map.put("other", OTHER);
        return map;
    }

    private static final Map<String, JobPostingContentSectionValueEnum> createEnumsMap() {
        Map<String, JobPostingContentSectionValueEnum> map = new HashMap<>();
        map.put("responsibilities", JobPostingContentSectionValueEnum.RESPONSIBILITIES);
        map.put("skills", JobPostingContentSectionValueEnum.SKILLS);
        map.put("benefits", JobPostingContentSectionValueEnum.BENEFITS);
        map.put("company_overview", JobPostingContentSectionValueEnum.COMPANY_OVERVIEW);
        map.put("description", JobPostingContentSectionValueEnum.DESCRIPTION);
        map.put("other", JobPostingContentSectionValueEnum.OTHER);
        return map;
    }
    
    @SuppressWarnings("serial")
    public static final class _Serializer extends StdSerializer<JobPostingContentSectionValue> {

        protected _Serializer() {
            super(JobPostingContentSectionValue.class);
        }

        @Override
        public void serialize(JobPostingContentSectionValue value, JsonGenerator g, SerializerProvider provider)
                throws IOException, JsonProcessingException {
            g.writeObject(value.value);
        }
    }

    @SuppressWarnings("serial")
    public static final class _Deserializer extends StdDeserializer<JobPostingContentSectionValue> {

        protected _Deserializer() {
            super(JobPostingContentSectionValue.class);
        }

        @Override
        public JobPostingContentSectionValue deserialize(JsonParser p, DeserializationContext ctxt)
                throws IOException, JacksonException {
            String v = p.readValueAs(new TypeReference<String>() {});
            // use the factory method to ensure we get singletons
            return JobPostingContentSectionValue.of(v);
        }
    }
    
    public enum JobPostingContentSectionValueEnum {

        RESPONSIBILITIES("responsibilities"),
        SKILLS("skills"),
        BENEFITS("benefits"),
        COMPANY_OVERVIEW("company_overview"),
        DESCRIPTION("description"),
        OTHER("other"),;

        private final String value;

        private JobPostingContentSectionValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}
