/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */


package com.stackone.stackone_client_java.models.components;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

public class SocialLink {

    /**
     * Type of the social link
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("type")
    private JsonNullable<String> type;

    /**
     * URL of the social link
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("url")
    private JsonNullable<String> url;

    @JsonCreator
    public SocialLink(
            @JsonProperty("type") JsonNullable<String> type,
            @JsonProperty("url") JsonNullable<String> url) {
        Utils.checkNotNull(type, "type");
        Utils.checkNotNull(url, "url");
        this.type = type;
        this.url = url;
    }
    
    public SocialLink() {
        this(JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * Type of the social link
     */
    @JsonIgnore
    public JsonNullable<String> type() {
        return type;
    }

    /**
     * URL of the social link
     */
    @JsonIgnore
    public JsonNullable<String> url() {
        return url;
    }

    public final static Builder builder() {
        return new Builder();
    }

    /**
     * Type of the social link
     */
    public SocialLink withType(String type) {
        Utils.checkNotNull(type, "type");
        this.type = JsonNullable.of(type);
        return this;
    }

    /**
     * Type of the social link
     */
    public SocialLink withType(JsonNullable<String> type) {
        Utils.checkNotNull(type, "type");
        this.type = type;
        return this;
    }

    /**
     * URL of the social link
     */
    public SocialLink withUrl(String url) {
        Utils.checkNotNull(url, "url");
        this.url = JsonNullable.of(url);
        return this;
    }

    /**
     * URL of the social link
     */
    public SocialLink withUrl(JsonNullable<String> url) {
        Utils.checkNotNull(url, "url");
        this.url = url;
        return this;
    }
    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SocialLink other = (SocialLink) o;
        return 
            Objects.deepEquals(this.type, other.type) &&
            Objects.deepEquals(this.url, other.url);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            type,
            url);
    }
    
    @Override
    public String toString() {
        return Utils.toString(SocialLink.class,
                "type", type,
                "url", url);
    }
    
    public final static class Builder {
 
        private JsonNullable<String> type = JsonNullable.undefined();
 
        private JsonNullable<String> url = JsonNullable.undefined();  
        
        private Builder() {
          // force use of static builder() method
        }

        /**
         * Type of the social link
         */
        public Builder type(String type) {
            Utils.checkNotNull(type, "type");
            this.type = JsonNullable.of(type);
            return this;
        }

        /**
         * Type of the social link
         */
        public Builder type(JsonNullable<String> type) {
            Utils.checkNotNull(type, "type");
            this.type = type;
            return this;
        }

        /**
         * URL of the social link
         */
        public Builder url(String url) {
            Utils.checkNotNull(url, "url");
            this.url = JsonNullable.of(url);
            return this;
        }

        /**
         * URL of the social link
         */
        public Builder url(JsonNullable<String> url) {
            Utils.checkNotNull(url, "url");
            this.url = url;
            return this;
        }
        
        public SocialLink build() {
            return new SocialLink(
                type,
                url);
        }
    }
}

