/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(using=_Deserializer.class)
@JsonSerialize(using=_Serializer.class)
public class RejectedReasonValue {
    public static final RejectedReasonValue REJECTED_BY_CANDIDATE = new RejectedReasonValue("rejected_by_candidate");
    public static final RejectedReasonValue REJECTED_BY_ORGANIZATION = new RejectedReasonValue("rejected_by_organization");
    public static final RejectedReasonValue OTHER = new RejectedReasonValue("other");
    public static final RejectedReasonValue UNKNOWN = new RejectedReasonValue("unknown");
    public static final RejectedReasonValue UNMAPPED_VALUE = new RejectedReasonValue("unmapped_value");
    private static final Map<String, RejectedReasonValue> values = RejectedReasonValue.createValuesMap();
    private static final Map<String, RejectedReasonValueEnum> enums = RejectedReasonValue.createEnumsMap();
    private final String value;

    private RejectedReasonValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RejectedReasonValue of(String value) {
        Class<RejectedReasonValue> clazz = RejectedReasonValue.class;
        synchronized (RejectedReasonValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new RejectedReasonValue((String)v));
        }
    }

    public String value() {
        return this.value;
    }

    public Optional<RejectedReasonValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RejectedReasonValue other = (RejectedReasonValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "RejectedReasonValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RejectedReasonValue[] values() {
        Class<RejectedReasonValue> clazz = RejectedReasonValue.class;
        synchronized (RejectedReasonValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new RejectedReasonValue[0]);
        }
    }

    private static final Map<String, RejectedReasonValue> createValuesMap() {
        LinkedHashMap<String, RejectedReasonValue> map = new LinkedHashMap<String, RejectedReasonValue>();
        map.put("rejected_by_candidate", REJECTED_BY_CANDIDATE);
        map.put("rejected_by_organization", REJECTED_BY_ORGANIZATION);
        map.put("other", OTHER);
        map.put("unknown", UNKNOWN);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, RejectedReasonValueEnum> createEnumsMap() {
        HashMap<String, RejectedReasonValueEnum> map = new HashMap<String, RejectedReasonValueEnum>();
        map.put("rejected_by_candidate", RejectedReasonValueEnum.REJECTED_BY_CANDIDATE);
        map.put("rejected_by_organization", RejectedReasonValueEnum.REJECTED_BY_ORGANIZATION);
        map.put("other", RejectedReasonValueEnum.OTHER);
        map.put("unknown", RejectedReasonValueEnum.UNKNOWN);
        map.put("unmapped_value", RejectedReasonValueEnum.UNMAPPED_VALUE);
        return map;
    }

    public static enum RejectedReasonValueEnum {
        REJECTED_BY_CANDIDATE("rejected_by_candidate"),
        REJECTED_BY_ORGANIZATION("rejected_by_organization"),
        OTHER("other"),
        UNKNOWN("unknown"),
        UNMAPPED_VALUE("unmapped_value");

        private final String value;

        private RejectedReasonValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static final class _Deserializer
    extends StdDeserializer<RejectedReasonValue> {
        protected _Deserializer() {
            super(RejectedReasonValue.class);
        }

        public RejectedReasonValue deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            String v = (String)p.readValueAs((TypeReference)new TypeReference<String>(){});
            return RejectedReasonValue.of(v);
        }
    }

    public static final class _Serializer
    extends StdSerializer<RejectedReasonValue> {
        protected _Serializer() {
            super(RejectedReasonValue.class);
        }

        public void serialize(RejectedReasonValue value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObject((Object)value.value);
        }
    }
}

