/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonDeserialize(using=_Deserializer.class)
@JsonSerialize(using=_Serializer.class)
public class JobPostingContentSectionValue {
    public static final JobPostingContentSectionValue RESPONSIBILITIES = new JobPostingContentSectionValue("responsibilities");
    public static final JobPostingContentSectionValue SKILLS = new JobPostingContentSectionValue("skills");
    public static final JobPostingContentSectionValue BENEFITS = new JobPostingContentSectionValue("benefits");
    public static final JobPostingContentSectionValue COMPANY_OVERVIEW = new JobPostingContentSectionValue("company_overview");
    public static final JobPostingContentSectionValue DESCRIPTION = new JobPostingContentSectionValue("description");
    public static final JobPostingContentSectionValue OTHER = new JobPostingContentSectionValue("other");
    private static final Map<String, JobPostingContentSectionValue> values = JobPostingContentSectionValue.createValuesMap();
    private static final Map<String, JobPostingContentSectionValueEnum> enums = JobPostingContentSectionValue.createEnumsMap();
    private final String value;

    private JobPostingContentSectionValue(String value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JobPostingContentSectionValue of(String value) {
        Class<JobPostingContentSectionValue> clazz = JobPostingContentSectionValue.class;
        synchronized (JobPostingContentSectionValue.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return values.computeIfAbsent(value, v -> new JobPostingContentSectionValue((String)v));
        }
    }

    public String value() {
        return this.value;
    }

    public Optional<JobPostingContentSectionValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(this.value, null));
    }

    public boolean isKnown() {
        return this.asEnum().isPresent();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JobPostingContentSectionValue other = (JobPostingContentSectionValue)obj;
        return Objects.equals(this.value, other.value);
    }

    public String toString() {
        return "JobPostingContentSectionValue [value=" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JobPostingContentSectionValue[] values() {
        Class<JobPostingContentSectionValue> clazz = JobPostingContentSectionValue.class;
        synchronized (JobPostingContentSectionValue.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return values.values().toArray(new JobPostingContentSectionValue[0]);
        }
    }

    private static final Map<String, JobPostingContentSectionValue> createValuesMap() {
        LinkedHashMap<String, JobPostingContentSectionValue> map = new LinkedHashMap<String, JobPostingContentSectionValue>();
        map.put("responsibilities", RESPONSIBILITIES);
        map.put("skills", SKILLS);
        map.put("benefits", BENEFITS);
        map.put("company_overview", COMPANY_OVERVIEW);
        map.put("description", DESCRIPTION);
        map.put("other", OTHER);
        return map;
    }

    private static final Map<String, JobPostingContentSectionValueEnum> createEnumsMap() {
        HashMap<String, JobPostingContentSectionValueEnum> map = new HashMap<String, JobPostingContentSectionValueEnum>();
        map.put("responsibilities", JobPostingContentSectionValueEnum.RESPONSIBILITIES);
        map.put("skills", JobPostingContentSectionValueEnum.SKILLS);
        map.put("benefits", JobPostingContentSectionValueEnum.BENEFITS);
        map.put("company_overview", JobPostingContentSectionValueEnum.COMPANY_OVERVIEW);
        map.put("description", JobPostingContentSectionValueEnum.DESCRIPTION);
        map.put("other", JobPostingContentSectionValueEnum.OTHER);
        return map;
    }

    public static enum JobPostingContentSectionValueEnum {
        RESPONSIBILITIES("responsibilities"),
        SKILLS("skills"),
        BENEFITS("benefits"),
        COMPANY_OVERVIEW("company_overview"),
        DESCRIPTION("description"),
        OTHER("other");

        private final String value;

        private JobPostingContentSectionValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }

    public static final class _Deserializer
    extends StdDeserializer<JobPostingContentSectionValue> {
        protected _Deserializer() {
            super(JobPostingContentSectionValue.class);
        }

        public JobPostingContentSectionValue deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            String v = (String)p.readValueAs((TypeReference)new TypeReference<String>(){});
            return JobPostingContentSectionValue.of(v);
        }
    }

    public static final class _Serializer
    extends StdSerializer<JobPostingContentSectionValue> {
        protected _Serializer() {
            super(JobPostingContentSectionValue.class);
        }

        public void serialize(JobPostingContentSectionValue value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObject((Object)value.value);
        }
    }
}

